/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.internal;

import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.internal.AbstractComponentManagerFactory;
import org.xwiki.component.internal.multi.ComponentManagerManager;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;

public abstract class AbstractEnityComponentManagerFactory
extends AbstractComponentManagerFactory {
    @Inject
    @Named(value="explicit")
    private EntityReferenceResolver<String> resolver;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private ComponentManagerManager manager;

    protected abstract EntityType getEntityType();

    public ComponentManager createComponentManager(String namespace, ComponentManager parentComponentManager) {
        ComponentManager parent;
        EntityReference reference = this.resolver.resolve((Object)namespace.substring(this.getEntityType().getLowerCase().length() + 1), this.getEntityType(), new Object[0]);
        EntityReference parentReference = reference.getParent();
        if (parentReference != null) {
            String parentNamespace = parentReference.getType().getLowerCase() + ":" + (String)this.serializer.serialize(parentReference, new Object[0]);
            parent = this.manager.getComponentManager(parentNamespace, true);
        } else {
            parent = parentComponentManager;
        }
        return this.defaultFactory.createComponentManager(namespace, parent);
    }
}

