/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.chart.internal;

import java.awt.Color;
import java.awt.Paint;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jfree.chart.JFreeChart;
import org.xwiki.chart.ChartCustomizer;
import org.xwiki.chart.internal.DrawingSupplierFactory;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="color")
@Singleton
public class ColorChartCustomizer
implements ChartCustomizer {
    private static final String BACKGROUND_COLOR = "backgroundColor";
    private static final String PLOT_BACKGROUND_COLOR = "plotBackgroundColor";
    private static final String PLOT_BORDER_COLOR = "plotBorderColor";
    private static final String BORDER_COLOR = "borderColor";
    private static final String LEGEND_BACKGROUND_COLOR = "legendBackgroundColor";

    @Override
    public void customize(JFreeChart jfchart, Map<String, String> parameters) {
        DrawingSupplierFactory drawingSupplierFactory = new DrawingSupplierFactory();
        jfchart.getPlot().setDrawingSupplier(drawingSupplierFactory.createDrawingSupplier(parameters));
        if (parameters.get(PLOT_BACKGROUND_COLOR) != null) {
            jfchart.getPlot().setBackgroundPaint((Paint)this.convertColor(parameters.get(PLOT_BACKGROUND_COLOR)));
        }
        if (parameters.get(BACKGROUND_COLOR) != null) {
            jfchart.setBackgroundPaint((Paint)this.convertColor(parameters.get(BACKGROUND_COLOR)));
        }
        if (parameters.get(LEGEND_BACKGROUND_COLOR) != null) {
            jfchart.getLegend().setBackgroundPaint((Paint)this.convertColor(parameters.get(LEGEND_BACKGROUND_COLOR)));
        }
        if (parameters.get(PLOT_BORDER_COLOR) != null) {
            jfchart.getPlot().setOutlinePaint((Paint)this.convertColor(parameters.get(PLOT_BORDER_COLOR)));
        }
        if (parameters.get(BORDER_COLOR) != null) {
            jfchart.setBorderPaint((Paint)this.convertColor(parameters.get(BORDER_COLOR)));
        }
    }

    private Color convertColor(String colorInHex) {
        int red = Integer.parseInt(colorInHex.substring(0, 2), 16);
        int green = Integer.parseInt(colorInHex.substring(2, 4), 16);
        int blue = Integer.parseInt(colorInHex.substring(4, 6), 16);
        return new Color(red, green, blue);
    }
}

