/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.chart.source.table;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.xwiki.chart.dataset.DatasetType;
import org.xwiki.rendering.block.TableBlock;
import org.xwiki.rendering.block.TableCellBlock;
import org.xwiki.rendering.block.TableRowBlock;
import org.xwiki.rendering.internal.macro.chart.source.AbstractDataSource;
import org.xwiki.rendering.internal.macro.chart.source.SimpleChartModel;
import org.xwiki.rendering.internal.macro.chart.source.table.TableCategoryDatasetBuilder;
import org.xwiki.rendering.internal.macro.chart.source.table.TableDatasetBuilder;
import org.xwiki.rendering.internal.macro.chart.source.table.TablePieDatasetBuilder;
import org.xwiki.rendering.internal.macro.chart.source.table.TableTimeTableXYDatasetBuilder;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.transformation.MacroTransformationContext;

public abstract class AbstractTableBlockDataSource
extends AbstractDataSource {
    private static final int LETTER_RANGE_LENGTH = 26;
    private static final String RANGE_PARAM = "range";
    private static final String SERIES_PARAM = "series";
    private static final String SERIES_COLUMNS = "columns";
    private static final String SERIES_ROWS = "rows";
    private static final String NO_LIMIT_SYMBOL = ".";
    private static final Pattern RANGE_PATTERN = Pattern.compile("^([A-Z]+|\\.)([0-9]+|\\.)-([A-Z]+|\\.)([0-9]+|\\.)$");
    private static final String CATEGORY_DATASET = "category";
    private static final String TIME_SERIES_DATASET = "timeseries";
    private static final String PIE_DATASET = "pie";
    private static final String DEFAULT_DATASET = "category";
    private String range;
    private String series;
    @Inject
    @Named(value="plain/1.0")
    private BlockRenderer plainTextBlockRenderer;

    @Override
    public void buildDataset(String macroContent, Map<String, String> parameters, MacroTransformationContext context) throws MacroExecutionException {
        this.validateParameters(parameters);
        TableBlock tableBlock = this.getTableBlock(macroContent, context);
        int[] dataRange = this.getDataRange(tableBlock);
        this.setChartModel(new SimpleChartModel());
        TableDatasetBuilder datasetBuilder = switch (this.getDatasetType()) {
            case DatasetType.CATEGORY -> new TableCategoryDatasetBuilder();
            case DatasetType.PIE -> new TablePieDatasetBuilder();
            case DatasetType.TIMETABLE_XY -> new TableTimeTableXYDatasetBuilder();
            default -> throw new MacroExecutionException(String.format("Unsupported dataset type [%s]", this.getDatasetType().getName()));
        };
        this.setAxes();
        datasetBuilder.setLocaleConfiguration(this.getLocaleConfiguration());
        datasetBuilder.setParameters(parameters);
        if (SERIES_COLUMNS.equals(this.series)) {
            datasetBuilder.setTranspose(true);
        }
        this.buildDataset(tableBlock, dataRange, datasetBuilder);
        this.setDataset(datasetBuilder.getDataset());
    }

    private void getRowKeys(TableBlock tableBlock, int startRow, int endRow, int startColumn, TableDatasetBuilder datasetBuilder) throws MacroExecutionException {
        datasetBuilder.setNumberOfRows(endRow - startRow + 1);
        if (startColumn > 0) {
            HashSet rowKeySet = new HashSet();
            for (int i = startRow; i <= endRow; ++i) {
                TableRowBlock tableRow = (TableRowBlock)tableBlock.getChildren().get(i);
                String key = this.cellContentAsString((TableCellBlock)tableRow.getChildren().get(startColumn - 1));
                datasetBuilder.setRowHeading(i - startRow, key);
            }
        } else {
            for (int i = startRow; i <= endRow; ++i) {
                datasetBuilder.setRowHeading(i - startRow, "R" + i);
            }
        }
    }

    private void getColumnKeys(TableBlock tableBlock, int startColumn, int endColumn, int startRow, TableDatasetBuilder datasetBuilder) throws MacroExecutionException {
        datasetBuilder.setNumberOfColumns(endColumn - startColumn + 1);
        if (startRow > 0) {
            TableRowBlock tableRow = (TableRowBlock)tableBlock.getChildren().get(startRow - 1);
            for (int i = startColumn; i <= endColumn; ++i) {
                String key = this.cellContentAsString((TableCellBlock)tableRow.getChildren().get(i));
                datasetBuilder.setColumnHeading(i - startColumn, key);
            }
        } else {
            for (int i = startColumn; i <= endColumn; ++i) {
                datasetBuilder.setColumnHeading(i - startColumn, "C" + i);
            }
        }
    }

    private void buildDataset(TableBlock tableBlock, int[] dataRange, TableDatasetBuilder datasetBuilder) throws MacroExecutionException {
        int startRow = dataRange[0];
        int startColumn = dataRange[1];
        int endRow = dataRange[2];
        int endColumn = dataRange[3];
        if (startRow == 0 && datasetBuilder.forceRowHeadings()) {
            startRow = 1;
        }
        if (startColumn == 0 && datasetBuilder.forceColumnHeadings()) {
            startColumn = 1;
        }
        this.getRowKeys(tableBlock, startRow, endRow, startColumn, datasetBuilder);
        this.getColumnKeys(tableBlock, startColumn, endColumn, startRow, datasetBuilder);
        for (int i = startRow; i <= endRow; ++i) {
            if (i < tableBlock.getChildren().size()) {
                TableRowBlock tableRow = (TableRowBlock)tableBlock.getChildren().get(i);
                for (int j = startColumn; j <= endColumn; ++j) {
                    if (j >= tableRow.getChildren().size()) {
                        throw new MacroExecutionException("Data range (columns) overflow.");
                    }
                    Number value = this.cellContentAsNumber((TableCellBlock)tableRow.getChildren().get(j));
                    datasetBuilder.setValue(i - startRow, j - startColumn, value);
                }
                continue;
            }
            throw new MacroExecutionException("Data range (rows) overflow.");
        }
    }

    protected static Integer getColumnNumberFromIdentifier(String identifier) {
        char j;
        if (NO_LIMIT_SYMBOL.equals(identifier)) {
            return null;
        }
        int i = 0;
        int result = -1;
        while (i < identifier.length() && Character.isUpperCase(j = identifier.charAt(i++))) {
            result = (result + 1) * 26 + j - 65;
        }
        return result;
    }

    private static Integer getRowNumberFromIdentifier(String identifier) {
        if (NO_LIMIT_SYMBOL.equals(identifier)) {
            return null;
        }
        return Integer.parseInt(identifier) - 1;
    }

    private Number cellContentAsNumber(TableCellBlock cell) throws MacroExecutionException {
        String stringContent = this.cellContentAsString(cell);
        try {
            return NumberUtils.createNumber((String)StringUtils.trim((String)stringContent));
        }
        catch (NumberFormatException ex) {
            throw new MacroExecutionException(String.format("Invalid number: [%s].", stringContent));
        }
    }

    private String cellContentAsString(TableCellBlock cell) {
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        this.plainTextBlockRenderer.render((Collection)cell.getChildren(), (WikiPrinter)printer);
        return printer.toString();
    }

    private Integer[] getDataRangeFromParameter() throws MacroExecutionException {
        Integer startColumn = null;
        Integer endColumn = null;
        Integer startRow = null;
        Integer endRow = null;
        if (this.range != null) {
            Matcher m = RANGE_PATTERN.matcher(this.range);
            if (!m.matches()) {
                throw new MacroExecutionException(String.format("Invalid range specification: [%s].", this.range));
            }
            startColumn = AbstractTableBlockDataSource.getColumnNumberFromIdentifier(m.group(1));
            startRow = AbstractTableBlockDataSource.getRowNumberFromIdentifier(m.group(2));
            endColumn = AbstractTableBlockDataSource.getColumnNumberFromIdentifier(m.group(3));
            endRow = AbstractTableBlockDataSource.getRowNumberFromIdentifier(m.group(4));
            if (startColumn != null && endColumn != null && startColumn > endColumn) {
                throw new MacroExecutionException(String.format("Invalid data range, end column mustn't come before start column: [%s].", this.range));
            }
            if (startRow != null && endRow != null && startRow > endRow) {
                throw new MacroExecutionException(String.format("Invalid data range, end row mustn't come before start row: [%s].", this.range));
            }
        }
        return new Integer[]{startRow, startColumn, endRow, endColumn};
    }

    protected int[] getDataRange(TableBlock tableBlock) throws MacroExecutionException {
        TableRowBlock firstRow;
        int columnCount;
        Integer[] r = this.getDataRangeFromParameter();
        int rowCount = tableBlock.getChildren().size();
        if (rowCount > 0 && (columnCount = (firstRow = (TableRowBlock)tableBlock.getChildren().get(0)).getChildren().size()) > 0) {
            return new int[]{r[0] != null ? r[0] : 0, r[1] != null ? r[1] : 0, r[2] != null ? r[2] : rowCount - 1, r[3] != null ? r[3] : columnCount - 1};
        }
        throw new MacroExecutionException("Data table is incomplete.");
    }

    @Override
    public void validateDatasetType() throws MacroExecutionException {
        super.validateDatasetType();
        switch (this.getDatasetType()) {
            case CATEGORY: {
                break;
            }
            case PIE: {
                break;
            }
            case TIMETABLE_XY: {
                break;
            }
            default: {
                throw new MacroExecutionException(String.format("Dataset type [%s] is not supported by the table data source.", this.getDatasetType().getName()));
            }
        }
    }

    protected abstract TableBlock getTableBlock(String var1, MacroTransformationContext var2) throws MacroExecutionException;

    @Override
    protected boolean setParameter(String key, String value) throws MacroExecutionException {
        if (RANGE_PARAM.equals(key)) {
            this.range = value;
            return true;
        }
        if (SERIES_PARAM.equals(key)) {
            this.series = value;
            return true;
        }
        return false;
    }

    @Override
    protected void validateParameters() throws MacroExecutionException {
        if (this.series == null) {
            this.series = this.getDatasetType() == DatasetType.CATEGORY ? SERIES_ROWS : SERIES_COLUMNS;
        } else if (!SERIES_COLUMNS.equals(this.series) && !SERIES_ROWS.equals(this.series)) {
            throw new MacroExecutionException(String.format("Unsupported value for parameter [%s]: [%s]", SERIES_PARAM, this.series));
        }
    }
}

