/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.captcha.internal;

import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.captcha.internal.JCaptchaResourceReference;
import org.xwiki.component.annotation.Component;
import org.xwiki.resource.CreateResourceReferenceException;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.internal.AbstractResourceReferenceResolver;

@Component
@Named(value="jcaptcha")
@Singleton
public class JCaptchaResourceReferenceResolver
extends AbstractResourceReferenceResolver {
    public ResourceReference resolve(ExtendedURL extendedURL, ResourceType resourceType, Map<String, Object> parameters) throws CreateResourceReferenceException, UnsupportedResourceReferenceException {
        List segments = extendedURL.getSegments();
        if (segments.size() <= 1) {
            throw new CreateResourceReferenceException(String.format("Invalid JCaptcha URL format [%s]", extendedURL.toString()));
        }
        String type = (String)segments.get(0);
        String engine = (String)segments.get(1);
        JCaptchaResourceReference reference = new JCaptchaResourceReference(type, engine);
        this.copyParameters(extendedURL, (ResourceReference)reference);
        return reference;
    }
}

