/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.attachment.validation.internal.step;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.attachment.AttachmentAccessWrapper;
import org.xwiki.attachment.validation.AttachmentValidationConfiguration;
import org.xwiki.attachment.validation.AttachmentValidationException;
import org.xwiki.attachment.validation.AttachmentValidationStep;
import org.xwiki.component.annotation.Component;
import org.xwiki.tika.internal.TikaUtils;

@Component
@Singleton
@Named(value="mimetype")
public class MimetypeAttachmentValidationStep
implements AttachmentValidationStep {
    public static final String HINT = "mimetype";
    @Inject
    private AttachmentValidationConfiguration attachmentValidationConfiguration;
    @Inject
    private Logger logger;

    public void validate(AttachmentAccessWrapper wrapper) throws AttachmentValidationException {
        try (InputStream inputStream = wrapper.getInputStream();){
            boolean hasBlockerMimetypes;
            String mimeType = this.detectMimeType(inputStream, wrapper.getFileName()).toLowerCase();
            List allowedMimetypes = this.attachmentValidationConfiguration.getAllowedMimetypes();
            List blockerMimetypes = this.attachmentValidationConfiguration.getBlockerMimetypes();
            boolean hasAllowedMimetypes = !allowedMimetypes.isEmpty();
            boolean bl = hasBlockerMimetypes = !blockerMimetypes.isEmpty();
            if (hasAllowedMimetypes && !this.checkMimetype(allowedMimetypes, mimeType) || hasBlockerMimetypes && this.checkMimetype(blockerMimetypes, mimeType)) {
                throw new AttachmentValidationException(String.format("Invalid mimetype [%s]", mimeType), Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode(), "attachment.validation.mimetype.rejected", List.of(allowedMimetypes, blockerMimetypes), null);
            }
        }
        catch (IOException e) {
            throw new AttachmentValidationException(String.format("Failed to read the input stream for [%s]", wrapper), (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "attachment.validation.inputStream.error");
        }
    }

    private boolean checkMimetype(List<String> mimetypes, String mimeType) {
        return mimetypes.stream().anyMatch(mimeTypePattern -> {
            if (!mimeTypePattern.contains("*")) {
                return Objects.equals(mimeTypePattern, mimeType);
            }
            String[] parts = mimeTypePattern.split("\\*", 2);
            return mimeType.startsWith(parts[0]) && mimeType.endsWith(parts[1]);
        });
    }

    private String detectMimeType(InputStream inputStream, String fileName) {
        String mimeType;
        try {
            mimeType = TikaUtils.detect((InputStream)inputStream, (String)fileName);
        }
        catch (Exception e) {
            this.logger.warn("Failed to identify the mimetype of [{}]. Cause: [{}]", (Object)fileName, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            mimeType = "";
        }
        return mimeType;
    }
}

