/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.attachment.internal.refactoring.job;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.io.IOException;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.attachment.internal.AttachmentsManager;
import org.xwiki.attachment.internal.RedirectAttachmentClassDocumentInitializer;
import org.xwiki.attachment.refactoring.MoveAttachmentRequest;
import org.xwiki.attachment.refactoring.event.AttachmentMovedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.event.Event;
import org.xwiki.refactoring.internal.job.AbstractEntityJob;
import org.xwiki.refactoring.job.EntityJobStatus;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

@Component
@Named(value="refactoring/attachment/move")
public class MoveAttachmentJob
extends AbstractEntityJob<MoveAttachmentRequest, EntityJobStatus<MoveAttachmentRequest>> {
    public static final String HINT = "refactoring/attachment/move";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private ContextualLocalizationManager contextualLocalizationManager;
    @Inject
    private EntityReferenceSerializer<String> referenceSerializer;
    @Inject
    private AttachmentsManager attachmentsManager;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> documentReferenceUserReferenceResolver;

    public String getType() {
        return HINT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(EntityReference source) {
        this.progressManager.pushLevelProgress(2, (Object)this);
        AttachmentReference destination = (AttachmentReference)((MoveAttachmentRequest)this.request).getProperty("destination");
        boolean autoRedirect = (Boolean)((MoveAttachmentRequest)this.request).getProperty("autoRedirect");
        XWiki wiki = ((XWikiContext)this.xcontextProvider.get()).getWiki();
        this.modelBridge.setContextUserReference(((MoveAttachmentRequest)this.request).getUserReference());
        try {
            if (this.checkMoveRights(source, (EntityReference)destination)) {
                this.progressManager.startStep((Object)this);
                this.moveAttachment(source, destination, autoRedirect, wiki);
                this.progressManager.endStep((Object)this);
                this.progressManager.startStep((Object)this);
                this.observationManager.notify((Event)new AttachmentMovedEvent((AttachmentReference)source, destination), (Object)this, (Object)this.request);
                this.progressManager.endStep((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private boolean checkMoveRights(EntityReference source, EntityReference destination) {
        boolean hasSourceRight = this.hasAccess(Right.VIEW, source) && this.hasAccess(Right.EDIT, source);
        boolean hasDestinationRight = this.hasAccess(Right.EDIT, destination);
        if (!hasSourceRight) {
            this.logger.error("You don't have sufficient permissions over the source attachment [{}].", (Object)source);
        } else if (!hasDestinationRight) {
            this.logger.error("You don't have sufficient permissions over the destination attachment [{}].", (Object)destination);
        }
        return hasSourceRight && hasDestinationRight;
    }

    private void moveAttachment(EntityReference source, AttachmentReference destination, boolean autoRedirect, XWiki wiki) {
        try {
            XWikiDocument sourceDocument = wiki.getDocument(source.getParent(), (XWikiContext)this.xcontextProvider.get());
            XWikiDocument targetDocument = wiki.getDocument(destination.getParent(), (XWikiContext)this.xcontextProvider.get());
            XWikiAttachment sourceAttachment = sourceDocument.getExactAttachment(source.getName());
            UserReference authorUserReference = this.documentReferenceUserReferenceResolver.resolve((Object)((MoveAttachmentRequest)this.request).getUserReference(), new Object[0]);
            sourceDocument.getAuthors().setEffectiveMetadataAuthor(authorUserReference);
            sourceDocument.getAuthors().setOriginalMetadataAuthor(authorUserReference);
            targetDocument.getAuthors().setEffectiveMetadataAuthor(authorUserReference);
            targetDocument.getAuthors().setOriginalMetadataAuthor(authorUserReference);
            sourceDocument.removeAttachment(sourceAttachment);
            this.addAttachment(targetDocument, sourceAttachment, destination.getName());
            this.attachmentsManager.removeExistingRedirection(destination.getName(), targetDocument);
            if (autoRedirect) {
                this.initializeAutoRedirection(source, destination, sourceDocument);
            }
            if (Objects.equals(source.getParent(), destination.getParent())) {
                wiki.saveDocument(sourceDocument, this.contextualLocalizationManager.getTranslationPlain("attachment.job.saveDocument.inPlace", new Object[]{source.getName(), destination.getName()}), (XWikiContext)this.xcontextProvider.get());
            } else {
                this.transactionalMove(wiki, sourceDocument, targetDocument, sourceAttachment.getFilename(), destination.getName());
            }
        }
        catch (XWikiException | IOException e) {
            this.logger.warn("Failed to move attachment [{}] to [{}]. Cause: [{}]", new Object[]{source, destination, ExceptionUtils.getRootCauseMessage((Throwable)e)});
        }
    }

    private void transactionalMove(XWiki wiki, XWikiDocument sourceDocument, XWikiDocument targetDocument, String sourceFileName, String targetFileName) throws XWikiException, IOException {
        String sourceSerialized = (String)this.referenceSerializer.serialize((EntityReference)sourceDocument.getDocumentReference(), new Object[0]);
        String destinationSerialized = (String)this.referenceSerializer.serialize((EntityReference)targetDocument.getDocumentReference(), new Object[0]);
        String historyMessageSource = this.contextualLocalizationManager.getTranslationPlain("attachment.job.saveDocument.source", new Object[]{destinationSerialized});
        String historyMessageTarget = this.contextualLocalizationManager.getTranslationPlain("attachment.job.saveDocument.target", new Object[]{sourceSerialized});
        wiki.saveDocument(sourceDocument, historyMessageSource, (XWikiContext)this.xcontextProvider.get());
        try {
            wiki.saveDocument(targetDocument, historyMessageTarget, (XWikiContext)this.xcontextProvider.get());
        }
        catch (Exception e) {
            XWikiAttachment attachment = targetDocument.getExactAttachment(targetFileName);
            this.addAttachment(sourceDocument, attachment, sourceFileName);
            targetDocument.removeAttachment(attachment);
            String historyMessageRollbackTarget = this.contextualLocalizationManager.getTranslationPlain("attachment.job.rollbackDocument.target", new Object[]{sourceFileName, sourceSerialized});
            wiki.saveDocument(sourceDocument, historyMessageRollbackTarget, true, (XWikiContext)this.xcontextProvider.get());
            throw e;
        }
    }

    private void initializeAutoRedirection(EntityReference source, AttachmentReference destination, XWikiDocument sourceDocument) throws XWikiException {
        int idx = sourceDocument.createXObject((EntityReference)RedirectAttachmentClassDocumentInitializer.REFERENCE, (XWikiContext)this.xcontextProvider.get());
        BaseObject xObject = sourceDocument.getXObject((EntityReference)RedirectAttachmentClassDocumentInitializer.REFERENCE, idx);
        if (xObject != null) {
            xObject.setStringValue("sourceName", source.getName());
            xObject.setStringValue("targetLocation", (String)this.entityReferenceSerializer.serialize(destination.getParent(), new Object[0]));
            xObject.setStringValue("targetName", destination.getName());
        }
    }

    private void addAttachment(XWikiDocument targetDocument, XWikiAttachment oldAttachment, String newName) throws IOException, XWikiException {
        XWikiAttachment newAttachment = oldAttachment.clone(newName, (XWikiContext)this.xcontextProvider.get());
        newAttachment.setDoc(targetDocument);
        targetDocument.setAttachment(newAttachment);
    }
}

