/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.attachment.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.AbstractMandatoryDocumentInitializer;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.StringProperty;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.uiextension.internal.WikiUIExtensionConstants;

@Component
@Singleton
@Named(value="Attachment.Code.MoveAttachment")
@Priority(value=2000)
public class MoveAttachmentDocumentInitializer
extends AbstractMandatoryDocumentInitializer {
    private static final String UIPX_ID = "org.xwiki.platform.template.header.after";
    private static final String UIX_ID = "org.xwiki.platform.attachment.header.after.move";
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;

    public MoveAttachmentDocumentInitializer() {
        super((EntityReference)new LocalDocumentReference(Arrays.asList("Attachment", "Code"), "MoveAttachment"));
    }

    public boolean updateDocument(XWikiDocument document) {
        Boolean hidden;
        boolean updated = super.updateDocument(document);
        List uIExtensionObjects = document.getXObjects((EntityReference)WikiUIExtensionConstants.UI_EXTENSION_CLASS);
        BaseObject xObject = uIExtensionObjects.stream().filter(Objects::nonNull).filter(object -> Objects.equals(object.getStringValue("extensionPointId"), UIPX_ID) && Objects.equals(object.getStringValue("name"), UIX_ID)).findFirst().orElse(null);
        if (xObject == null) {
            updated = true;
            try {
                EntityReference uIExtensionClass = new EntityReference((EntityReference)WikiUIExtensionConstants.UI_EXTENSION_CLASS);
                XWikiContext context = (XWikiContext)this.contextProvider.get();
                xObject = document.newXObject(uIExtensionClass, context);
                xObject.set("extensionPointId", (Object)UIPX_ID, context);
                xObject.set("name", (Object)UIX_ID, context);
                xObject.set("content", (Object)"{{velocity}}\n{{html clean=\"false\"}}\n<script id=\"attachment-move-config\" type=\"application/json\">$jsontool.serialize({\n  'treeWebjar': $!services.webjars.url('org.xwiki.platform:xwiki-platform-tree-webjar', 'require-config.min.js', {'evaluate': true})})</script>\n{{/html}}\n{{/velocity}}", context);
                xObject.set("scope", (Object)"wiki", context);
            }
            catch (XWikiException e) {
                this.logger.error("Error while trying to initialize a [org.xwiki.platform.template.header.after] UIX in [Attachment.Code.MoveAttachment].", (Throwable)e);
            }
        } else if (xObject.safeget("content") instanceof StringProperty) {
            xObject.setLargeStringValue("content", xObject.getStringValue("content"));
            updated = true;
        }
        if (Boolean.FALSE.equals(hidden = document.isHidden())) {
            updated = true;
            document.setHidden(Boolean.valueOf(true));
        }
        return updated;
    }
}

