/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.attachment.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.attachment.internal.AttachmentsManager;
import org.xwiki.attachment.internal.RedirectAttachmentClassDocumentInitializer;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;

@Component
@Singleton
public class DefaultAttachmentsManager
implements AttachmentsManager {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;

    @Override
    public boolean available(AttachmentReference attachmentLocation) throws XWikiException {
        XWikiDocument document = ((XWikiContext)this.xcontextProvider.get()).getWiki().getDocument(attachmentLocation.getDocumentReference(), (XWikiContext)this.xcontextProvider.get());
        boolean available = document == null ? false : document.getExactAttachment(attachmentLocation.getName()) == null;
        return available;
    }

    @Override
    public Optional<AttachmentReference> getRedirection(AttachmentReference attachmentReference) throws XWikiException {
        XWikiDocument document = ((XWikiContext)this.xcontextProvider.get()).getWiki().getDocument(attachmentReference.getDocumentReference(), (XWikiContext)this.xcontextProvider.get());
        if (document == null) {
            return Optional.empty();
        }
        return document.getXObjects((EntityReference)RedirectAttachmentClassDocumentInitializer.REFERENCE).stream().filter(Objects::nonNull).filter(redirectObj -> Objects.equals(redirectObj.getStringValue("sourceName"), attachmentReference.getName())).findFirst().map(redirectObj -> {
            String targetName = redirectObj.getStringValue("targetName");
            DocumentReference targetLocation = this.documentReferenceResolver.resolve((Object)redirectObj.getStringValue("targetLocation"), new Object[0]);
            return new AttachmentReference(targetName, targetLocation);
        });
    }

    @Override
    public boolean removeExistingRedirection(String attachmentName, XWikiDocument targetDocument) {
        boolean changed = false;
        List targetRedirections = targetDocument.getXObjects((EntityReference)RedirectAttachmentClassDocumentInitializer.REFERENCE);
        for (BaseObject targetRedirection : targetRedirections) {
            if (targetRedirection == null || !Objects.equals(targetRedirection.getStringValue("sourceName"), attachmentName)) continue;
            changed = true;
            targetDocument.removeXObject(targetRedirection);
        }
        return changed;
    }
}

