/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.rest.internal.representations;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import org.xwiki.annotation.rest.model.jaxb.AnnotationField;
import org.xwiki.annotation.rest.model.jaxb.AnnotationRequest;
import org.xwiki.annotation.rest.model.jaxb.ObjectFactory;
import org.xwiki.rest.JAXRSUtils;
import org.xwiki.rest.XWikiRestComponent;

public abstract class AbstractFormUrlEncodedAnnotationRequestReader<T extends AnnotationRequest>
implements MessageBodyReader<T>,
XWikiRestComponent {
    protected static final String REQUESTED_FIELD = "request_field";
    protected static final String FILTER_FIELD_PREFIX = "filter_";
    @Inject
    private JAXRSUtils jaxrs;

    protected abstract T getReadObjectInstance(ObjectFactory var1);

    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        MultivaluedMap form = this.jaxrs.readForm(mediaType, annotations, entityStream);
        ObjectFactory objectFactory = new ObjectFactory();
        T annotationRequest = this.getReadObjectInstance(objectFactory);
        for (Map.Entry entry : form.entrySet()) {
            for (String value : (List)entry.getValue()) {
                this.saveField(annotationRequest, (String)entry.getKey(), value, objectFactory);
            }
        }
        return annotationRequest;
    }

    protected boolean saveField(T readObject, String key, String value, ObjectFactory objectFactory) {
        if (REQUESTED_FIELD.equals(key)) {
            ((AnnotationRequest)readObject).getRequest().getFields().add(value);
            return true;
        }
        if (key.startsWith(FILTER_FIELD_PREFIX)) {
            AnnotationField filterField = objectFactory.createAnnotationField();
            filterField.setName(key.substring(FILTER_FIELD_PREFIX.length()));
            filterField.setValue(value);
            ((AnnotationRequest)readObject).getFilter().getFields().add(filterField);
            return true;
        }
        return false;
    }
}

