/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.rest.internal;

import java.util.Locale;
import javax.inject.Named;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.xwiki.annotation.rest.internal.AbstractAnnotationsRESTResource;
import org.xwiki.annotation.rest.model.jaxb.AnnotationAddRequest;
import org.xwiki.annotation.rest.model.jaxb.AnnotationResponse;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.rest.XWikiRestException;

@Component
@Named(value="org.xwiki.annotation.rest.internal.AnnotationsTranslationRESTResource")
@Path(value="/wikis/{wikiName}/spaces/{spaceName: .+}/pages/{pageName}/translations/{language}/annotations")
public class AnnotationsTranslationRESTResource
extends AbstractAnnotationsRESTResource {
    @GET
    public Response doGetAnnotatedContent(@PathParam(value="spaceName") @Encoded String spaceNames, @PathParam(value="pageName") String page, @PathParam(value="wikiName") String wiki, @PathParam(value="language") String language) throws XWikiRestException {
        DocumentReference documentReference = new DocumentReference(wiki, this.parseSpaceSegments(spaceNames), page, LocaleUtils.toLocale((String)language, (Locale)Locale.ROOT));
        return this.getAnnotatedContent(documentReference);
    }

    @POST
    public AnnotationResponse doPostAnnotation(@PathParam(value="wikiName") String wiki, @PathParam(value="spaceName") @Encoded String spaceNames, @PathParam(value="pageName") String page, @PathParam(value="language") String language, AnnotationAddRequest request) throws XWikiRestException {
        DocumentReference documentReference = new DocumentReference(wiki, this.parseSpaceSegments(spaceNames), page);
        return this.postAnnotation(documentReference, request);
    }
}

