/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.rest.internal;

import com.xpn.xwiki.XWikiException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.xwiki.annotation.AnnotationServiceException;
import org.xwiki.annotation.rest.internal.AbstractAnnotationRESTResource;
import org.xwiki.annotation.rest.model.jaxb.AnnotationAddRequest;
import org.xwiki.annotation.rest.model.jaxb.AnnotationField;
import org.xwiki.annotation.rest.model.jaxb.AnnotationFieldCollection;
import org.xwiki.annotation.rest.model.jaxb.AnnotationRequest;
import org.xwiki.annotation.rest.model.jaxb.AnnotationResponse;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

public abstract class AbstractAnnotationsRESTResource
extends AbstractAnnotationRESTResource {
    private static final String ANNOTATION_REQUEST_REQUESTED_FIELD_PARAMETER = "request_field";
    private static final String ANNOTATION_REQUEST_FILTER_PARAMETER_PREFIX = "filter_";

    protected Response getAnnotatedContent(DocumentReference documentReference) {
        try {
            this.updateContext(documentReference);
            String documentName = (String)this.referenceSerializer.serialize((EntityReference)documentReference, new Object[0]);
            if (!this.annotationRightService.canViewAnnotatedTarget(documentName, this.getXWikiUser())) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            MultivaluedMap parameters = this.uriInfo.getQueryParameters();
            AnnotationRequest request = new AnnotationRequest();
            AnnotationFieldCollection fields = new AnnotationFieldCollection();
            ArrayList<AnnotationField> annotationFields = new ArrayList<AnnotationField>();
            AnnotationRequest.Request requestedFields = new AnnotationRequest.Request();
            for (Map.Entry entry : parameters.entrySet()) {
                String name = (String)entry.getKey();
                if (Strings.CS.startsWith((CharSequence)name, (CharSequence)ANNOTATION_REQUEST_FILTER_PARAMETER_PREFIX)) {
                    for (String value : (List)entry.getValue()) {
                        AnnotationField field = new AnnotationField();
                        field.setName(StringUtils.substringAfter((String)name, (String)ANNOTATION_REQUEST_FILTER_PARAMETER_PREFIX));
                        field.setValue(value);
                        annotationFields.add(field);
                    }
                    continue;
                }
                if (!Strings.CS.equals(name, ANNOTATION_REQUEST_REQUESTED_FIELD_PARAMETER)) continue;
                requestedFields.getFields().addAll((Collection)entry.getValue());
            }
            request.setRequest(requestedFields);
            fields.getFields().addAll(annotationFields);
            request.setFilter(fields);
            AnnotationResponse response = this.getSuccessResponseWithAnnotatedContent(documentName, request);
            return Response.ok((Object)response).build();
        }
        catch (XWikiException | AnnotationServiceException e) {
            this.getLogger().error(e.getMessage(), e);
            return Response.ok((Object)this.getErrorResponse(e)).build();
        }
    }

    protected AnnotationResponse postAnnotation(DocumentReference documentReference, AnnotationAddRequest request) {
        try {
            this.updateContext(documentReference);
            String documentName = (String)this.referenceSerializer.serialize((EntityReference)documentReference, new Object[0]);
            if (!this.annotationRightService.canAddAnnotation(documentName, this.getXWikiUser())) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            Map<String, Object> annotationMetadata = this.getMap(request.getAnnotation());
            this.handleTemporaryUploadedFiles(documentReference, annotationMetadata);
            this.annotationService.addAnnotation(documentName, request.getSelection(), request.getSelectionContext(), request.getSelectionOffset(), this.getXWikiUser(), annotationMetadata);
            this.cleanTemporaryUploadedFiles(documentReference);
            return this.getSuccessResponseWithAnnotatedContent(documentName, request);
        }
        catch (XWikiException | AnnotationServiceException e) {
            this.getLogger().error(e.getMessage(), e);
            return this.getErrorResponse(e);
        }
    }
}

