/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.reference;

import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.ObjectReference;

public class IndexedObjectReference
extends ObjectReference {
    protected String className;
    protected Integer objectNumber;

    public IndexedObjectReference(EntityReference reference) {
        super(reference);
    }

    public IndexedObjectReference(String className, Integer objectNumber, EntityReference parent) {
        super((String)(objectNumber != null ? className + "[" + objectNumber + "]" : className), new DocumentReference(parent));
    }

    public String getClassName() {
        return this.className != null ? this.className : this.getName();
    }

    public Integer getObjectNumber() {
        return this.objectNumber;
    }

    protected void setName(String name) {
        super.setName(name);
        this.className = name;
        this.objectNumber = null;
        int closePosition = name.lastIndexOf(93);
        if (closePosition < 0 || closePosition != name.length() - 1) {
            return;
        }
        int openPosition = name.lastIndexOf(91);
        if (openPosition < 0) {
            return;
        }
        String numberString = name.substring(openPosition + 1, closePosition);
        try {
            this.objectNumber = Integer.parseInt(numberString);
            this.className = name.substring(0, openPosition);
        }
        catch (NumberFormatException e) {
            return;
        }
    }
}

