/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.renderer;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.xwiki.annotation.renderer.GeneratorEmptyBlockChainingListener;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.listener.InlineFilterListener;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.chaining.AbstractChainingListener;
import org.xwiki.rendering.listener.chaining.EmptyBlockChainingListener;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.reference.link.LinkLabelGenerator;

public class LinkLabelGeneratorChainingListener
extends AbstractChainingListener {
    protected LinkLabelGenerator linkLabelGenerator;
    protected StreamParser linkLabelParser;

    public LinkLabelGeneratorChainingListener(LinkLabelGenerator linkLabelGenerator, StreamParser linkLabelParser, ListenerChain listenerChain) {
        this.setListenerChain(listenerChain);
        this.linkLabelGenerator = linkLabelGenerator;
        this.linkLabelParser = linkLabelParser;
    }

    protected EmptyBlockChainingListener getEmptyBlockState() {
        return (GeneratorEmptyBlockChainingListener)this.getListenerChain().getListener(GeneratorEmptyBlockChainingListener.class);
    }

    public void endLink(ResourceReference reference, boolean freestanding, Map<String, String> parameters) {
        if (this.getEmptyBlockState().isCurrentContainerBlockEmpty()) {
            String linkLabel = reference.getReference();
            ResourceType resourceType = reference.getType();
            if (ResourceType.DOCUMENT.equals((Object)resourceType) || ResourceType.SPACE.equals((Object)resourceType) || ResourceType.PAGE.equals((Object)resourceType)) {
                linkLabel = this.linkLabelGenerator.generate(reference);
            }
            HashMap<String, String> formatParams = new HashMap<String, String>();
            formatParams.put("class", "wikigeneratedlinkcontent");
            super.beginFormat(Format.NONE, formatParams);
            InlineFilterListener inlineFilterListener = new InlineFilterListener();
            inlineFilterListener.setWrappedListener((Listener)this.getListenerChain().getNextListener(((Object)((Object)this)).getClass()));
            try {
                this.linkLabelParser.parse((Reader)new StringReader(linkLabel), (Listener)inlineFilterListener);
            }
            catch (ParseException e) {
                super.onRawText(linkLabel, this.linkLabelParser.getSyntax());
            }
            super.endFormat(Format.NONE, formatParams);
        }
        super.endLink(reference, freestanding, parameters);
    }
}

