/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.renderer;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.annotation.Annotation;
import org.xwiki.annotation.content.ContentAlterer;
import org.xwiki.annotation.content.TextExtractor;
import org.xwiki.annotation.internal.renderer.AnnotationGeneratorChainingListener;
import org.xwiki.annotation.renderer.AnnotationPrintRenderer;
import org.xwiki.annotation.renderer.ChainingPrintRenderer;
import org.xwiki.annotation.renderer.GeneratorEmptyBlockChainingListener;
import org.xwiki.annotation.renderer.LinkLabelGeneratorChainingListener;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.listener.chaining.BlockStateChainingListener;
import org.xwiki.rendering.listener.chaining.ChainingListener;
import org.xwiki.rendering.listener.chaining.EmptyBlockChainingListener;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.listener.chaining.MetaDataStateChainingListener;
import org.xwiki.rendering.parser.StreamParser;
import org.xwiki.rendering.renderer.AbstractChainingPrintRenderer;
import org.xwiki.rendering.renderer.reference.link.LinkLabelGenerator;

public abstract class AbstractAnnotationRenderer
extends AbstractChainingPrintRenderer
implements Initializable,
AnnotationPrintRenderer {
    @Inject
    @Named(value="whitespace")
    protected ContentAlterer selectionAlterer;
    @Inject
    @Named(value="plain/1.0")
    protected StreamParser plainTextParser;
    @Inject
    protected TextExtractor textExtractor;
    protected AnnotationGeneratorChainingListener annotationsGenerator;

    public void initialize() throws InitializationException {
        ListenerChain chain = new ListenerChain();
        this.setListenerChain(chain);
        this.annotationsGenerator = new AnnotationGeneratorChainingListener(this.selectionAlterer, chain, this.textExtractor);
        chain.addListener((ChainingListener)this);
        chain.addListener((ChainingListener)new GeneratorEmptyBlockChainingListener(chain));
        chain.addListener((ChainingListener)new LinkLabelGeneratorChainingListener(this.getLinkLabelGenerator(), this.plainTextParser, chain));
        chain.addListener((ChainingListener)this.annotationsGenerator);
        chain.addListener((ChainingListener)new BlockStateChainingListener(chain));
        chain.addListener((ChainingListener)new EmptyBlockChainingListener(chain));
        chain.addListener((ChainingListener)new MetaDataStateChainingListener(chain));
        chain.addListener((ChainingListener)this.getAnnotationPrintRenderer(chain));
    }

    public abstract ChainingPrintRenderer getAnnotationPrintRenderer(ListenerChain var1);

    public abstract LinkLabelGenerator getLinkLabelGenerator();

    @Override
    public void setAnnotations(Collection<Annotation> annotations) {
        this.annotationsGenerator.setAnnotations(annotations);
    }
}

