/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.internal.renderer;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.annotation.content.AlteredContent;
import org.xwiki.annotation.content.ContentAlterer;
import org.xwiki.annotation.content.TextExtractor;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.listener.ListType;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.renderer.AbstractChainingPrintRenderer;
import org.xwiki.rendering.syntax.Syntax;

public class PlainTextNormalizingChainingRenderer
extends AbstractChainingPrintRenderer {
    private ContentAlterer textCleaner;
    private TextExtractor textExtractor;
    private boolean isInWhitespace = true;
    private boolean hasPrinted;

    public PlainTextNormalizingChainingRenderer(ContentAlterer textCleaner, TextExtractor textExtractor, ListenerChain listenerChain) {
        this.textCleaner = textCleaner;
        this.textExtractor = textExtractor;
        this.setListenerChain(listenerChain);
    }

    public void onWord(String word) {
        this.printText(word);
    }

    public void onSpecialSymbol(char symbol) {
        this.printText("" + symbol);
    }

    public void onVerbatim(String content, boolean inline, Map<String, String> parameters) {
        if (!inline || Character.isWhitespace(content.charAt(0))) {
            this.printSpace();
        }
        AlteredContent cleanedContent = this.textCleaner.alter(content);
        this.printText(cleanedContent.getContent().toString());
        if (!inline || Character.isWhitespace(content.charAt(content.length() - 1))) {
            this.printSpace();
        }
    }

    public void onRawText(String text, Syntax syntax) {
        if (StringUtils.isNotEmpty((CharSequence)text)) {
            if (Character.isWhitespace(text.charAt(0))) {
                this.printSpace();
            }
            AlteredContent cleanedContent = this.textCleaner.alter(this.textExtractor.extractText(text, syntax));
            this.printText(cleanedContent.getContent().toString());
            if (Character.isWhitespace(text.charAt(text.length() - 1))) {
                this.printSpace();
            }
        }
    }

    public void onSpace() {
        this.printSpace();
    }

    protected void printSpace() {
        this.isInWhitespace = true;
    }

    protected void printText(String text) {
        if (this.isInWhitespace && this.hasPrinted) {
            this.getPrinter().print(" ");
        }
        this.getPrinter().print(text);
        this.hasPrinted = true;
        this.isInWhitespace = false;
    }

    public void onEmptyLines(int count) {
        if (count > 0) {
            this.printSpace();
        }
    }

    public void onNewLine() {
        this.printSpace();
    }

    public void onHorizontalLine(Map<String, String> parameters) {
        this.printSpace();
    }

    public void beginDefinitionDescription() {
        this.printSpace();
    }

    public void endDefinitionDescription() {
        this.printSpace();
    }

    public void beginDefinitionList(Map<String, String> parameters) {
        this.printSpace();
    }

    public void endDefinitionList(Map<String, String> parameters) {
        this.printSpace();
    }

    public void beginDefinitionTerm() {
        this.printSpace();
    }

    public void endDefinitionTerm() {
        this.printSpace();
    }

    public void beginGroup(Map<String, String> parameters) {
        this.printSpace();
    }

    public void endGroup(Map<String, String> parameters) {
        this.printSpace();
    }

    public void beginHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.printSpace();
    }

    public void endHeader(HeaderLevel level, String id, Map<String, String> parameters) {
        this.printSpace();
    }

    public void beginList(ListType type, Map<String, String> parameters) {
        this.printSpace();
    }

    public void endList(ListType type, Map<String, String> parameters) {
        this.printSpace();
    }

    public void beginListItem() {
        this.printSpace();
    }

    public void beginListItem(Map<String, String> parameters) {
        this.printSpace();
    }

    public void endListItem() {
        this.printSpace();
    }

    public void endListItem(Map<String, String> parameters) {
        this.printSpace();
    }

    public void beginParagraph(Map<String, String> parameters) {
        this.printSpace();
    }

    public void endParagraph(Map<String, String> parameters) {
        this.printSpace();
    }

    public void beginQuotation(Map<String, String> parameters) {
        this.printSpace();
    }

    public void endQuotation(Map<String, String> parameters) {
        this.printSpace();
    }

    public void beginQuotationLine() {
        this.printSpace();
    }

    public void endQuotationLine() {
        this.printSpace();
    }

    public void beginTable(Map<String, String> parameters) {
        this.printSpace();
    }

    public void endTable(Map<String, String> parameters) {
        this.printSpace();
    }

    public void beginTableRow(Map<String, String> parameters) {
        this.printSpace();
    }

    public void endTableRow(Map<String, String> parameters) {
        this.printSpace();
    }

    public void beginTableHeadCell(Map<String, String> parameters) {
        this.printSpace();
    }

    public void endTableHeadCell(Map<String, String> parameters) {
        this.printSpace();
    }

    public void beginTableCell(Map<String, String> parameters) {
        this.printSpace();
    }

    public void endTableCell(Map<String, String> parameters) {
        this.printSpace();
    }
}

