/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.internal.renderer;

import java.lang.invoke.CallSite;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import org.xwiki.annotation.Annotation;
import org.xwiki.annotation.renderer.AnnotationEvent;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.renderer.printer.XHTMLWikiPrinter;
import org.xwiki.xml.html.HTMLElementSanitizer;

public class AnnotationMarkersXHTMLPrinter
extends XHTMLWikiPrinter {
    private static final String ANNOTATION_MARKER = "span";
    private boolean open;
    private List<Annotation> renderedAnnotations = new LinkedList<Annotation>();

    public AnnotationMarkersXHTMLPrinter(WikiPrinter printer, HTMLElementSanitizer htmlElementSanitizer) {
        super(printer, htmlElementSanitizer);
    }

    public void beginAnnotation(Annotation annotation) {
        this.renderedAnnotations.add(annotation);
        if (this.open) {
            this.printAnnotationStartMarker(annotation);
        }
    }

    public void endAnnotation(Annotation annotation) {
        int i;
        int annIndex = this.renderedAnnotations.indexOf(annotation);
        for (i = this.renderedAnnotations.size() - 1; i > annIndex; --i) {
            this.printAnnotationEndMarker(this.renderedAnnotations.get(i));
        }
        this.printAnnotationEndMarker(annotation);
        for (i = annIndex + 1; i < this.renderedAnnotations.size(); ++i) {
            this.printAnnotationStartMarker(this.renderedAnnotations.get(i));
        }
        this.renderedAnnotations.remove(annotation);
    }

    private void printAnnotationStartMarker(Annotation annotation) {
        LinkedHashMap<String, CallSite> attributes = new LinkedHashMap<String, CallSite>();
        attributes.put("class", (CallSite)((Object)("annotation ID" + annotation.getId())));
        this.printXMLStartElement(ANNOTATION_MARKER, attributes);
    }

    private void printAnnotationEndMarker(Annotation annotation) {
        this.printXMLEndElement(ANNOTATION_MARKER);
    }

    public void closeAllAnnotationMarkers() {
        if (this.open) {
            for (int i = this.renderedAnnotations.size() - 1; i >= 0; --i) {
                this.printAnnotationEndMarker(this.renderedAnnotations.get(i));
            }
            this.open = false;
        }
    }

    public void openAllAnnotationMarkers() {
        if (!this.open) {
            for (int i = 0; i < this.renderedAnnotations.size(); ++i) {
                this.printAnnotationStartMarker(this.renderedAnnotations.get(i));
            }
            this.open = true;
        }
    }

    public void printXMLWithAnnotations(String text, SortedMap<Integer, List<AnnotationEvent>> annotations) {
        int previous = 0;
        for (int index : annotations.keySet()) {
            String currentChunk = text.substring(previous, index);
            if (currentChunk.length() > 0) {
                this.printXML(currentChunk);
            }
            for (AnnotationEvent evt : (List)annotations.get(index)) {
                switch (evt.getType()) {
                    case START: {
                        this.beginAnnotation(evt.getAnnotation());
                        break;
                    }
                    case END: {
                        this.endAnnotation(evt.getAnnotation());
                        break;
                    }
                }
            }
            previous = index;
        }
        String chunk = text.substring(previous);
        if (chunk.length() > 0) {
            this.printXML(chunk);
        }
    }
}

