/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.internal.renderer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.annotation.Annotation;
import org.xwiki.annotation.content.AlteredContent;
import org.xwiki.annotation.content.ContentAlterer;
import org.xwiki.annotation.content.TextExtractor;
import org.xwiki.annotation.renderer.AnnotationEvent;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.listener.MetaData;
import org.xwiki.rendering.listener.QueueListener;
import org.xwiki.rendering.listener.chaining.ChainingListener;
import org.xwiki.rendering.listener.chaining.ListenerChain;
import org.xwiki.rendering.syntax.Syntax;

public class AnnotationGeneratorChainingListener
extends QueueListener
implements ChainingListener {
    private static final long serialVersionUID = -2790330640900288463L;
    private ListenerChain chain;
    private StringBuffer plainTextContent = new StringBuffer();
    private SortedMap<Integer, QueueListener.Event> eventsMapping = new TreeMap<Integer, QueueListener.Event>();
    private Map<QueueListener.Event, AlteredContent> alteredEventsContent = new HashMap<QueueListener.Event, AlteredContent>();
    private Collection<Annotation> annotations = Collections.emptyList();
    private ContentAlterer selectionAlterer;
    private Map<QueueListener.Event, SortedMap<Integer, List<AnnotationEvent>>> bookmarks = new HashMap<QueueListener.Event, SortedMap<Integer, List<AnnotationEvent>>>();
    private TextExtractor textExtractor;

    public AnnotationGeneratorChainingListener(ContentAlterer selectionAlterer, ListenerChain listenerChain, TextExtractor textExtractor) {
        this.chain = listenerChain;
        this.selectionAlterer = selectionAlterer;
        this.textExtractor = textExtractor;
    }

    public void onWord(String word) {
        super.onWord(word);
        this.handleRawText(word);
    }

    public void onSpecialSymbol(char symbol) {
        super.onSpecialSymbol(symbol);
        this.plainTextContent.append("" + symbol);
        this.eventsMapping.put(this.plainTextContent.length() - 1, (QueueListener.Event)this.getLast());
    }

    public void onVerbatim(String content, boolean inline, Map<String, String> parameters) {
        super.onVerbatim(content, inline, parameters);
        this.handleRawText(content);
    }

    private void handleRawText(String text) {
        AlteredContent cleanedContent = this.selectionAlterer.alter(text);
        String cleanedContentString = cleanedContent.getContent().toString();
        if (!StringUtils.isEmpty((CharSequence)cleanedContentString)) {
            this.plainTextContent.append(cleanedContentString);
            this.eventsMapping.put(this.plainTextContent.length() - 1, (QueueListener.Event)this.getLast());
            this.alteredEventsContent.put((QueueListener.Event)this.getLast(), cleanedContent);
        }
    }

    public void onRawText(String text, Syntax syntax) {
        super.onRawText(text, syntax);
        this.handleRawText(this.textExtractor.extractText(text, syntax));
    }

    public void endDocument(MetaData metadata) {
        super.endDocument(metadata);
        this.mapAnnotations();
        ChainingListener renderer = this.chain.getNextListener(((Object)((Object)this)).getClass());
        this.consumeEvents((Listener)renderer);
    }

    private void mapAnnotations() {
        for (Annotation ann : this.annotations) {
            String annotationContext = ann.getSelectionInContext();
            if (StringUtils.isEmpty((CharSequence)annotationContext)) continue;
            String alteredsLeftContext = StringUtils.isEmpty((CharSequence)ann.getSelectionLeftContext()) ? "" : this.selectionAlterer.alter(ann.getSelectionLeftContext()).getContent().toString();
            String alteredRightContext = StringUtils.isEmpty((CharSequence)ann.getSelectionRightContext()) ? "" : this.selectionAlterer.alter(ann.getSelectionRightContext()).getContent().toString();
            String alteredSelection = StringUtils.isEmpty((CharSequence)ann.getSelection()) ? "" : this.selectionAlterer.alter(ann.getSelection()).getContent().toString();
            String cleanedContext = alteredsLeftContext + alteredSelection + alteredRightContext;
            int contextIndex = this.plainTextContent.indexOf(cleanedContext);
            if (contextIndex < 0) continue;
            int alteredSelectionStartIndex = alteredsLeftContext.length();
            int alteredSelectionEndIndex = alteredSelectionStartIndex + alteredSelection.length() - 1;
            Object[] startEvt = this.getEventAndOffset(contextIndex + alteredSelectionStartIndex, false);
            Object[] endEvt = this.getEventAndOffset(contextIndex + alteredSelectionEndIndex, true);
            ann.set("plainTextStartOffset", contextIndex + alteredSelectionStartIndex);
            ann.set("plainTextEndOffset", contextIndex + alteredSelectionEndIndex + 1);
            if (startEvt == null || endEvt == null) continue;
            this.addBookmark((QueueListener.Event)startEvt[0], new AnnotationEvent(AnnotationEvent.AnnotationEventType.START, ann), (Integer)startEvt[1]);
            this.addBookmark((QueueListener.Event)endEvt[0], new AnnotationEvent(AnnotationEvent.AnnotationEventType.END, ann), (Integer)endEvt[1]);
        }
    }

    private Object[] getEventAndOffset(int index, boolean isEnd) {
        Map.Entry<Integer, QueueListener.Event> previous = null;
        for (Map.Entry<Integer, QueueListener.Event> range : this.eventsMapping.entrySet()) {
            if (index <= range.getKey()) {
                QueueListener.Event evt = range.getValue();
                int startIndex = 0;
                if (previous != null) {
                    startIndex = previous.getKey() + 1;
                }
                int offset = index - startIndex;
                AlteredContent alteredEventContent = this.alteredEventsContent.get(evt);
                if (alteredEventContent != null) {
                    offset = alteredEventContent.getInitialOffset(offset);
                }
                if (isEnd) {
                    ++offset;
                }
                return new Object[]{evt, offset};
            }
            previous = range;
        }
        return null;
    }

    protected void addBookmark(QueueListener.Event renderingEvent, AnnotationEvent annotationEvent, int offset) {
        SortedMap mappings = this.bookmarks.computeIfAbsent(renderingEvent, k -> new TreeMap());
        List events = mappings.computeIfAbsent(offset, k -> new LinkedList());
        this.addAnnotationEvent(annotationEvent, events);
    }

    protected void addAnnotationEvent(AnnotationEvent evt, List<AnnotationEvent> list) {
        if (list.size() == 0 || evt.getType() == AnnotationEvent.AnnotationEventType.START || list.get(list.size() - 1).getType() == AnnotationEvent.AnnotationEventType.END) {
            list.add(evt);
        } else {
            int index = 0;
            for (index = 0; index < list.size() && list.get(index).getType() != AnnotationEvent.AnnotationEventType.START; ++index) {
            }
            list.add(index, evt);
        }
    }

    public void consumeEvents(Listener listener) {
        while (!this.isEmpty()) {
            QueueListener.Event event = (QueueListener.Event)this.getFirst();
            event.eventType.fireEvent(listener, event.eventParameters);
            this.remove();
        }
    }

    public ListenerChain getListenerChain() {
        return this.chain;
    }

    public void setAnnotations(Collection<Annotation> annotations) {
        this.annotations = annotations;
    }

    public SortedMap<Integer, List<AnnotationEvent>> getAnnotationEvents() {
        return this.bookmarks.get(this.getFirst());
    }
}

