/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.annotation.Annotation;
import org.xwiki.annotation.AnnotationService;
import org.xwiki.annotation.AnnotationServiceException;
import org.xwiki.annotation.io.IOService;
import org.xwiki.annotation.io.IOServiceException;
import org.xwiki.annotation.io.IOTargetService;
import org.xwiki.annotation.maintainer.AnnotationState;
import org.xwiki.annotation.renderer.AnnotationPrintRenderer;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;

@Component
@Singleton
public class DefaultAnnotationService
implements AnnotationService {
    @Inject
    private IOService ioService;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private IOTargetService targetIoService;

    @Override
    public void addAnnotation(String target, String selection, String selectionContext, int offset, String author, Map<String, Object> metadata) throws AnnotationServiceException {
        try {
            String leftContext = selectionContext.substring(0, offset);
            String rightContext = selectionContext.substring(offset + selection.length());
            Annotation annotation = new Annotation(selection, leftContext, rightContext);
            annotation.setAuthor(author);
            List<String> skippedFields = Arrays.asList("selection", "selectionLeftContext", "selectionRightContext", "originalSelection", "author", "state");
            for (Map.Entry<String, Object> field : metadata.entrySet()) {
                if (skippedFields.contains(field.getKey())) continue;
                annotation.set(field.getKey(), field.getValue());
            }
            this.ioService.addAnnotation(target, annotation);
        }
        catch (IOServiceException e) {
            throw new AnnotationServiceException("An exception occurred when accessing the storage services", e);
        }
    }

    @Override
    public String getAnnotatedRenderedContent(String sourceReference, String sourceSyntax, String outputSyntax, Collection<Annotation> annotations) throws AnnotationServiceException {
        try {
            XDOM xdom = this.targetIoService.getXDOM(sourceReference, sourceSyntax);
            String outputSyntaxId = "annotations-" + outputSyntax;
            AnnotationPrintRenderer annotationsRenderer = (AnnotationPrintRenderer)this.componentManager.getInstance(AnnotationPrintRenderer.class, outputSyntaxId);
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            annotationsRenderer.setPrinter((WikiPrinter)printer);
            annotationsRenderer.setAnnotations(annotations);
            xdom.traverse((Listener)annotationsRenderer);
            return printer.toString();
        }
        catch (Exception exc) {
            throw new AnnotationServiceException(exc);
        }
    }

    @Override
    public String getAnnotatedHTML(String sourceReference) throws AnnotationServiceException {
        return this.getAnnotatedRenderedContent(sourceReference, null, "xhtml/1.0", this.getValidAnnotations(sourceReference));
    }

    @Override
    public Collection<Annotation> getAnnotations(String target) throws AnnotationServiceException {
        try {
            return this.ioService.getAnnotations(target);
        }
        catch (IOServiceException e) {
            throw new AnnotationServiceException(e);
        }
    }

    @Override
    public Collection<Annotation> getValidAnnotations(String target) throws AnnotationServiceException {
        try {
            ArrayList<Annotation> result = new ArrayList<Annotation>();
            for (Annotation it : this.ioService.getAnnotations(target)) {
                if (it.getState() != AnnotationState.SAFE && it.getState() != AnnotationState.UPDATED) continue;
                result.add(it);
            }
            return result;
        }
        catch (IOServiceException e) {
            throw new AnnotationServiceException(e);
        }
    }

    @Override
    public void removeAnnotation(String target, String annotationID) throws AnnotationServiceException {
        try {
            this.ioService.removeAnnotation(target, annotationID);
        }
        catch (IOServiceException e) {
            throw new AnnotationServiceException(e.getMessage());
        }
    }

    @Override
    public void updateAnnotation(String target, Annotation annotation) throws AnnotationServiceException {
        try {
            this.ioService.updateAnnotations(target, Arrays.asList(annotation));
        }
        catch (IOServiceException e) {
            throw new AnnotationServiceException(e.getMessage());
        }
    }

    @Override
    public Annotation getAnnotation(String target, String id) throws AnnotationServiceException {
        try {
            return this.ioService.getAnnotation(target, id);
        }
        catch (IOServiceException e) {
            throw new AnnotationServiceException(e.getMessage());
        }
    }
}

