/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.annotation.maintainer.AnnotationState;

public class Annotation {
    public static final String SELECTION_FIELD = "selection";
    public static final String SELECTION_LEFT_CONTEXT_FIELD = "selectionLeftContext";
    public static final String SELECTION_RIGHT_CONTEXT_FIELD = "selectionRightContext";
    public static final String STATE_FIELD = "state";
    public static final String ORIGINAL_SELECTION_FIELD = "originalSelection";
    public static final String AUTHOR_FIELD = "author";
    public static final String DATE_FIELD = "date";
    public static final String TARGET_FIELD = "target";
    public static final String PLAIN_TEXT_START_OFFSET_FIELD = "plainTextStartOffset";
    public static final String PLAIN_TEXT_END_OFFSET_FIELD = "plainTextEndOffset";
    protected final String id;
    protected Map<String, Object> fields = new HashMap<String, Object>();

    public Annotation(String id) {
        this.id = id;
    }

    public Annotation(String initialSelection, String leftContext, String rightContext) {
        this(null);
        this.setSelection(initialSelection, leftContext, rightContext);
        this.setState(AnnotationState.SAFE);
    }

    public String getAuthor() {
        return (String)this.fields.get(AUTHOR_FIELD);
    }

    public void setAuthor(String author) {
        this.fields.put(AUTHOR_FIELD, author);
    }

    public Date getDate() {
        return (Date)this.fields.get(DATE_FIELD);
    }

    public void setDate(Date date) {
        this.fields.put(DATE_FIELD, date);
    }

    public AnnotationState getState() {
        Object stateField = this.fields.get(STATE_FIELD);
        if (stateField == null) {
            return null;
        }
        if (AnnotationState.class.isAssignableFrom(stateField.getClass())) {
            return (AnnotationState)((Object)stateField);
        }
        if (String.class.isAssignableFrom(stateField.getClass())) {
            try {
                return AnnotationState.valueOf((String)stateField);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public void setState(AnnotationState state) {
        this.fields.put(STATE_FIELD, (Object)state);
    }

    public String getSelection() {
        return (String)this.fields.get(SELECTION_FIELD);
    }

    public String getSelectionInContext() {
        return (StringUtils.isEmpty((CharSequence)this.getSelectionLeftContext()) ? "" : this.getSelectionLeftContext()) + (StringUtils.isEmpty((CharSequence)this.getSelection()) ? "" : this.getSelection()) + (StringUtils.isEmpty((CharSequence)this.getSelectionRightContext()) ? "" : this.getSelectionRightContext());
    }

    public void setSelection(String selection, String contextLeft, String contextRight) {
        this.fields.put(SELECTION_FIELD, selection);
        this.fields.put(SELECTION_LEFT_CONTEXT_FIELD, contextLeft);
        this.fields.put(SELECTION_RIGHT_CONTEXT_FIELD, contextRight);
    }

    public void setSelection(String selection) {
        this.setSelection(selection, "", "");
    }

    public String getSelectionLeftContext() {
        return (String)this.fields.get(SELECTION_LEFT_CONTEXT_FIELD);
    }

    public String getSelectionRightContext() {
        return (String)this.fields.get(SELECTION_RIGHT_CONTEXT_FIELD);
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "id: " + this.getId() + " | author: " + this.getAuthor() + " | selection left context: " + this.getSelectionLeftContext() + " | selection: " + this.getSelection() + " | selection right context: " + this.getSelectionRightContext();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Annotation)) {
            return false;
        }
        Annotation other = (Annotation)obj;
        if (other.getId() != null || this.getId() != null) {
            return this.getId().equals(other.getId());
        }
        return this.getSelection().equals(other.getSelection()) && this.getSelectionLeftContext().equals(other.getSelectionLeftContext()) && this.getSelectionRightContext().equals(other.getSelectionRightContext());
    }

    public int hashCode() {
        return ((String)(this.getId() != null ? this.getId() : this.getSelectionLeftContext() + this.getSelection() + this.getSelectionRightContext())).hashCode();
    }

    public String getOriginalSelection() {
        return (String)this.fields.get(ORIGINAL_SELECTION_FIELD);
    }

    public void setOriginalSelection(String originalSelection) {
        this.fields.put(ORIGINAL_SELECTION_FIELD, originalSelection);
    }

    public Object get(String key) {
        return this.fields.get(key);
    }

    public Object set(String key, Object value) {
        return this.fields.put(key, value);
    }

    public Set<String> getFieldNames() {
        return this.fields.keySet();
    }
}

