/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls2.internal.data;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.activeinstalls2.internal.data.AbstractPingDataProvider;
import org.xwiki.activeinstalls2.internal.data.Ping;
import org.xwiki.activeinstalls2.internal.data.WikisPing;
import org.xwiki.component.annotation.Component;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="wikis")
@Singleton
public class WikisPingDataProvider
extends AbstractPingDataProvider {
    private static final String PROPERTY_TOTAL = "total";
    private static final String PROPERTY_WIKIS = "wikis";
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    @Override
    public Map<String, Property> provideMapping() {
        HashMap<String, Property> propertiesMap = new HashMap<String, Property>();
        propertiesMap.put(PROPERTY_TOTAL, Property.of(b1 -> b1.long_(b2 -> b2)));
        return Collections.singletonMap(PROPERTY_WIKIS, Property.of(b0 -> b0.object(b1 -> (ObjectBuilder)b1.properties(propertiesMap))));
    }

    @Override
    public void provideData(Ping ping) {
        Collection wikiIds;
        try {
            wikiIds = this.wikiDescriptorManager.getAllIds();
        }
        catch (WikiManagerException e) {
            this.logWarning("Failed to get the list of wikis", e);
            return;
        }
        WikisPing wikisPing = new WikisPing();
        wikisPing.setTotal(wikiIds.size());
        ping.setWikis(wikisPing);
    }
}

