/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls2.internal.data;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.activeinstalls2.internal.data.AbstractPingDataProvider;
import org.xwiki.activeinstalls2.internal.data.Ping;
import org.xwiki.activeinstalls2.internal.data.UsersPing;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="users")
@Singleton
public class UsersPingDataProvider
extends AbstractPingDataProvider {
    private static final String PROPERTY_TOTAL = "total";
    private static final String PROPERTY_MAIN = "main";
    private static final String PROPERTY_ALL = "wikis";
    private static final String PROPERTY_USERS = "users";
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private QueryManager queryManager;

    @Override
    public Map<String, Property> provideMapping() {
        HashMap<String, Property> propertiesMap = new HashMap<String, Property>();
        propertiesMap.put(PROPERTY_TOTAL, Property.of(b1 -> b1.long_(b2 -> b2)));
        propertiesMap.put(PROPERTY_MAIN, Property.of(b1 -> b1.long_(b2 -> b2)));
        propertiesMap.put(PROPERTY_ALL, Property.of(b1 -> b1.long_(b2 -> b2)));
        return Collections.singletonMap(PROPERTY_USERS, Property.of(b0 -> b0.object(b1 -> (ObjectBuilder)b1.properties(propertiesMap))));
    }

    @Override
    public void provideData(Ping ping) {
        Collection wikiIds;
        UsersPing usersPing = new UsersPing();
        try {
            wikiIds = this.wikiDescriptorManager.getAllIds();
        }
        catch (WikiManagerException e) {
            this.logWarning("Failed to get the list of wikis", e);
            return;
        }
        ArrayList<Long> allWikiCount = new ArrayList<Long>();
        long total = 0L;
        for (String wikiId : wikiIds) {
            try {
                long wikiCount = this.getUserCountInWiki(wikiId);
                total += wikiCount;
                if (this.wikiDescriptorManager.isMainWiki(wikiId)) {
                    usersPing.setMain(wikiCount);
                    continue;
                }
                allWikiCount.add(wikiCount);
            }
            catch (QueryException e) {
                this.logWarning(String.format("Failed to get the user count for wiki [%s]", wikiId), e);
            }
        }
        usersPing.setTotal(total);
        usersPing.setWikis(allWikiCount);
        ping.setUsers(usersPing);
    }

    private long getUserCountInWiki(String wikiId) throws QueryException {
        Query query = this.queryManager.createQuery("SELECT COUNT(DISTINCT doc.fullName) FROM Document doc, doc.object(XWiki.XWikiUsers) AS obj WHERE doc.fullName NOT IN (SELECT doc.fullName FROM XWikiDocument doc, BaseObject objLimit, IntegerProperty propActive WHERE objLimit.name = doc.fullName AND propActive.id.id = objLimit.id AND propActive.id.name = 'active' AND propActive.value = 0)", "xwql").setWiki(wikiId);
        List results = query.execute();
        return (Long)results.get(0);
    }
}

