/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls2.internal.data;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.activeinstalls2.internal.data.AbstractPingDataProvider;
import org.xwiki.activeinstalls2.internal.data.Ping;
import org.xwiki.activeinstalls2.internal.data.ServletContainerPing;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.Environment;
import org.xwiki.environment.internal.ServletEnvironment;

@Component
@Named(value="servlet")
@Singleton
public class ServletContainerPingDataProvider
extends AbstractPingDataProvider {
    private static final String SERVLET_INFO_VERSION_SEPARATOR = "/";
    private static final String SERVLET_INFO_OPTIONALSEPARATOR = "(";
    private static final String PROPERTY_SERVLET_CONTAINER_NAME = "name";
    private static final String PROPERTY_SERVLET_CONTAINER_VERSION = "version";
    private static final String PROPERTY_SERVLET = "servlet";
    @Inject
    private Environment environment;

    @Override
    public Map<String, Property> provideMapping() {
        HashMap<String, Property> propertiesMap = new HashMap<String, Property>();
        propertiesMap.put(PROPERTY_SERVLET_CONTAINER_NAME, Property.of(b1 -> b1.keyword(b2 -> b2)));
        propertiesMap.put(PROPERTY_SERVLET_CONTAINER_VERSION, Property.of(b1 -> b1.keyword(b2 -> b2)));
        return Collections.singletonMap(PROPERTY_SERVLET, Property.of(b0 -> b0.object(b1 -> (ObjectBuilder)b1.properties(propertiesMap))));
    }

    @Override
    public void provideData(Ping ping) {
        Environment environment = this.environment;
        if (environment instanceof ServletEnvironment) {
            ServletEnvironment servletEnvironment = (ServletEnvironment)environment;
            try {
                ServletContext servletContext = servletEnvironment.getServletContext();
                String serverInfo = servletContext.getServerInfo();
                ServletContainerPing servletContainerPing = new ServletContainerPing();
                servletContainerPing.setName(StringUtils.trim((String)StringUtils.substringBefore((String)serverInfo, (String)SERVLET_INFO_VERSION_SEPARATOR)));
                servletContainerPing.setVersion(StringUtils.trim((String)StringUtils.substringBefore((String)StringUtils.substringAfter((String)serverInfo, (String)SERVLET_INFO_VERSION_SEPARATOR), (String)SERVLET_INFO_OPTIONALSEPARATOR)));
                ping.setServletContainer(servletContainerPing);
            }
            catch (Exception e) {
                this.logWarning("Failed to compute Servlet container information", e);
            }
        }
    }
}

