/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls2.internal.data;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.activeinstalls2.internal.data.AbstractPingDataProvider;
import org.xwiki.activeinstalls2.internal.data.OSPing;
import org.xwiki.activeinstalls2.internal.data.Ping;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="os")
@Singleton
public class OsPingDataProvider
extends AbstractPingDataProvider {
    private static final String PROPERTY_OS_ARCH = "arch";
    private static final String PROPERTY_OS_NAME = "name";
    private static final String PROPERTY_OS_VERSION = "version";
    private static final String PROPERTY_OS = "os";

    @Override
    public Map<String, Property> provideMapping() {
        HashMap<String, Property> propertiesMap = new HashMap<String, Property>();
        propertiesMap.put(PROPERTY_OS_ARCH, Property.of(b1 -> b1.keyword(b2 -> b2)));
        propertiesMap.put(PROPERTY_OS_NAME, Property.of(b1 -> b1.keyword(b2 -> b2)));
        propertiesMap.put(PROPERTY_OS_VERSION, Property.of(b1 -> b1.keyword(b2 -> b2)));
        return Collections.singletonMap(PROPERTY_OS, Property.of(b0 -> b0.object(b1 -> (ObjectBuilder)b1.properties(propertiesMap))));
    }

    @Override
    public void provideData(Ping ping) {
        OSPing osPing = new OSPing();
        osPing.setArch(System.getProperty("os.arch"));
        osPing.setName(System.getProperty("os.name"));
        osPing.setVersion(System.getProperty("os.version"));
        ping.setOS(osPing);
    }
}

