/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls2.internal.data;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.activeinstalls2.internal.data.AbstractPingDataProvider;
import org.xwiki.activeinstalls2.internal.data.DocumentsPing;
import org.xwiki.activeinstalls2.internal.data.Ping;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="documents")
@Singleton
public class DocumentsPingDataProvider
extends AbstractPingDataProvider {
    private static final String PROPERTY_TOTAL = "total";
    private static final String PROPERTY_MAIN = "main";
    private static final String PROPERTY_ALL = "wikis";
    private static final String PROPERTY_DOCUMENTS = "documents";
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="count")
    private QueryFilter countFilter;

    @Override
    public Map<String, Property> provideMapping() {
        HashMap<String, Property> propertiesMap = new HashMap<String, Property>();
        propertiesMap.put(PROPERTY_TOTAL, Property.of(b1 -> b1.long_(b2 -> b2)));
        propertiesMap.put(PROPERTY_MAIN, Property.of(b1 -> b1.long_(b2 -> b2)));
        propertiesMap.put(PROPERTY_ALL, Property.of(b1 -> b1.long_(b2 -> b2)));
        return Collections.singletonMap(PROPERTY_DOCUMENTS, Property.of(b0 -> b0.object(b1 -> (ObjectBuilder)b1.properties(propertiesMap))));
    }

    @Override
    public void provideData(Ping ping) {
        Collection wikiIds;
        DocumentsPing documentsPing = new DocumentsPing();
        try {
            wikiIds = this.wikiDescriptorManager.getAllIds();
        }
        catch (WikiManagerException e) {
            this.logWarning("Failed to get the list of wikis", e);
            return;
        }
        ArrayList<Long> allWikiCount = new ArrayList<Long>();
        long total = 0L;
        for (String wikiId : wikiIds) {
            try {
                long wikiCount = this.getDocumentsCountInWiki(wikiId);
                total += wikiCount;
                if (this.wikiDescriptorManager.isMainWiki(wikiId)) {
                    documentsPing.setMain(wikiCount);
                    continue;
                }
                allWikiCount.add(wikiCount);
            }
            catch (QueryException e) {
                this.logWarning(String.format("Failed to get the documents count for wiki [%s]", wikiId), e);
            }
        }
        documentsPing.setTotal(total);
        documentsPing.setWikis(allWikiCount);
        ping.setDocuments(documentsPing);
    }

    private long getDocumentsCountInWiki(String wikiId) throws QueryException {
        List results = this.queryManager.createQuery("", "xwql").setWiki(wikiId).addFilter(this.countFilter).execute();
        return (Long)results.get(0);
    }
}

