/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls2.internal.data;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.activeinstalls2.internal.data.AbstractPingDataProvider;
import org.xwiki.activeinstalls2.internal.data.DistributionPing;
import org.xwiki.activeinstalls2.internal.data.ExtensionPing;
import org.xwiki.activeinstalls2.internal.data.Ping;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.version.Version;
import org.xwiki.instance.InstanceIdManager;

@Component
@Named(value="distribution")
@Singleton
public class DistributionPingDataProvider
extends AbstractPingDataProvider {
    static final String PROPERTY_INSTANCE_ID = "instanceId";
    static final String PROPERTY_DISTRIBUTION = "distribution";
    private static final String PROPERTY_DISTRIBUTION_VERSION = "version";
    private static final String PROPERTY_DISTRIBUTION_ID = "id";
    private static final String PROPERTY_DISTRIBUTION_FEATURES = "features";
    private static final String PROPERTY_EXTENSION = "extension";
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private Provider<InstanceIdManager> instanceIdManagerProvider;

    @Override
    public Map<String, Property> provideMapping() {
        HashMap<String, Property> propertiesMap = new HashMap<String, Property>();
        propertiesMap.put(PROPERTY_INSTANCE_ID, Property.of(b1 -> b1.keyword(b2 -> b2)));
        HashMap<String, Property> extensionMap = new HashMap<String, Property>();
        extensionMap.put(PROPERTY_DISTRIBUTION_VERSION, Property.of(b1 -> b1.keyword(b2 -> b2)));
        extensionMap.put(PROPERTY_DISTRIBUTION_ID, Property.of(b1 -> b1.keyword(b2 -> b2)));
        extensionMap.put(PROPERTY_DISTRIBUTION_FEATURES, Property.of(b1 -> b1.keyword(b2 -> b2)));
        propertiesMap.put(PROPERTY_EXTENSION, Property.of(b0 -> b0.object(b1 -> (ObjectBuilder)b1.properties(extensionMap))));
        return Collections.singletonMap(PROPERTY_DISTRIBUTION, Property.of(b0 -> b0.object(b1 -> (ObjectBuilder)b1.properties(propertiesMap))));
    }

    @Override
    public void provideData(Ping ping) {
        DistributionPing distributionPing = new DistributionPing();
        String instanceId = ((InstanceIdManager)this.instanceIdManagerProvider.get()).getInstanceId().toString();
        distributionPing.setInstanceId(instanceId);
        CoreExtension distributionExtension = this.coreExtensionRepository.getEnvironmentExtension();
        if (distributionExtension != null) {
            Collection features;
            Version distributionVersion;
            ExtensionPing extensionPing = new ExtensionPing();
            String distributionId = distributionExtension.getId().getId();
            if (distributionId != null) {
                extensionPing.setId(distributionId);
            }
            if ((distributionVersion = distributionExtension.getId().getVersion()) != null) {
                extensionPing.setVersion(distributionVersion.toString());
            }
            if (!(features = distributionExtension.getExtensionFeatures()).isEmpty()) {
                extensionPing.setFeatures(features.stream().map(ExtensionId::toString).toList());
            }
            distributionPing.setExtension(extensionPing);
        }
        ping.setDistribution(distributionPing);
    }
}

