/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls2.internal.data;

import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.util.ObjectBuilder;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.store.XWikiCacheStoreInterface;
import com.xpn.xwiki.store.XWikiHibernateBaseStore;
import com.xpn.xwiki.store.XWikiStoreInterface;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.activeinstalls2.internal.data.AbstractPingDataProvider;
import org.xwiki.activeinstalls2.internal.data.DatabasePing;
import org.xwiki.activeinstalls2.internal.data.Ping;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;

@Component
@Named(value="database")
@Singleton
public class DatabasePingDataProvider
extends AbstractPingDataProvider {
    private static final String PROPERTY_DB_NAME = "name";
    private static final String PROPERTY_DB_VERSION = "version";
    private static final String PROPERTY_DB = "database";
    @Inject
    private Execution execution;

    @Override
    public Map<String, Property> provideMapping() {
        HashMap<String, Property> propertiesMap = new HashMap<String, Property>();
        propertiesMap.put(PROPERTY_DB_NAME, Property.of(b1 -> b1.keyword(b2 -> b2)));
        propertiesMap.put(PROPERTY_DB_VERSION, Property.of(b1 -> b1.keyword(b2 -> b2)));
        return Collections.singletonMap(PROPERTY_DB, Property.of(b0 -> b0.object(b1 -> (ObjectBuilder)b1.properties(propertiesMap))));
    }

    @Override
    public void provideData(Ping ping) {
        DatabaseMetaData metaData;
        try {
            metaData = this.getDatabaseMetaData();
        }
        catch (Exception e) {
            this.logWarning("Failed to retrieve database metadata", e);
            metaData = null;
        }
        if (metaData != null) {
            DatabasePing databasePing = new DatabasePing();
            try {
                databasePing.setName(metaData.getDatabaseProductName());
            }
            catch (SQLException e) {
                this.logWarning("Failed to compute the database product name", e);
            }
            try {
                databasePing.setVersion(metaData.getDatabaseProductVersion());
            }
            catch (SQLException e) {
                this.logWarning("Failed to compute the database product version", e);
            }
            ping.setDatabase(databasePing);
        }
    }

    private DatabaseMetaData getDatabaseMetaData() {
        XWikiStoreInterface storeInterface;
        XWikiContext xcontext;
        DatabaseMetaData metaData = null;
        ExecutionContext ec = this.execution.getContext();
        if (ec != null && (xcontext = (XWikiContext)ec.getProperty("xwikicontext")) != null && XWikiHibernateBaseStore.class.isAssignableFrom((storeInterface = this.getStoreInterface(xcontext)).getClass())) {
            XWikiHibernateBaseStore baseStore = (XWikiHibernateBaseStore)storeInterface;
            metaData = baseStore.getDatabaseMetaData();
        }
        return metaData;
    }

    private XWikiStoreInterface getStoreInterface(XWikiContext xcontext) {
        XWikiStoreInterface storeInterface = xcontext.getWiki().getStore();
        if (storeInterface instanceof XWikiCacheStoreInterface) {
            XWikiCacheStoreInterface xwikiCacheStoreInterface = (XWikiCacheStoreInterface)storeInterface;
            storeInterface = xwikiCacheStoreInterface.getStore();
        }
        return storeInterface;
    }
}

