/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls2.internal;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.activeinstalls2.internal.ElasticsearchClientManager;
import org.xwiki.activeinstalls2.internal.PingDataProvider;
import org.xwiki.activeinstalls2.internal.PingSender;
import org.xwiki.activeinstalls2.internal.data.Ping;
import org.xwiki.component.annotation.Component;

@Component
@Singleton
public class DefaultPingSender
implements PingSender {
    @Inject
    private ElasticsearchClientManager clientManager;
    @Inject
    private Provider<List<PingDataProvider>> pingDataProviderProvider;

    @Override
    public void sendPing() throws Exception {
        ElasticsearchClient client = this.clientManager.getClient();
        if (client != null) {
            Ping ping = new Ping();
            this.provideData(ping);
            IndexResponse response = client.index(builder -> builder.index("installs3").document((Object)ping));
            if (response.result() != Result.Created) {
                throw new Exception(response.toString());
            }
        }
    }

    private void provideData(Ping ping) {
        for (PingDataProvider pingDataProvider : (List)this.pingDataProviderProvider.get()) {
            pingDataProvider.provideData(ping);
        }
    }
}

