/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls2.internal;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.xwiki.activeinstalls2.ActiveInstallsConfiguration;
import org.xwiki.activeinstalls2.internal.ElasticsearchClientManager;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;

@Component
@Singleton
public class DefaultElasticsearchClientManager
implements ElasticsearchClientManager,
Initializable,
Disposable {
    @Inject
    private Logger logger;
    @Inject
    private ActiveInstallsConfiguration configuration;
    private ElasticsearchClient client;
    private ElasticsearchTransport transport;

    public void initialize() throws InitializationException {
        String pingURL = this.configuration.getPingInstanceURL();
        if (!StringUtils.isEmpty((CharSequence)pingURL)) {
            RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{this.getPingHost(pingURL)});
            String path = this.getPingPath(pingURL);
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                restClientBuilder = restClientBuilder.setPathPrefix(path);
            }
            RestClient restClient = restClientBuilder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.useSystemProperties().setUserAgent(this.configuration.getUserAgent())).build();
            this.transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper());
            this.client = new ElasticsearchClient(this.transport);
        }
    }

    public void dispose() throws ComponentLifecycleException {
        if (this.transport != null) {
            try {
                this.transport.close();
            }
            catch (IOException e) {
                throw new ComponentLifecycleException("Failed to close the Active Installs transport layer", (Throwable)e);
            }
        }
    }

    @Override
    public ElasticsearchClient getClient() {
        return this.client;
    }

    private HttpHost getPingHost(String pingURLString) throws InitializationException {
        URI pingURL = this.getPingURL(pingURLString);
        return new HttpHost(pingURL.getHost(), pingURL.getPort(), pingURL.getScheme());
    }

    private String getPingPath(String pingURLString) throws InitializationException {
        URI pingURL = this.getPingURL(pingURLString);
        return pingURL.getPath();
    }

    private URI getPingURL(String pingURLString) throws InitializationException {
        try {
            return new URI(pingURLString);
        }
        catch (URISyntaxException e) {
            throw new InitializationException(String.format("Invalid Active Installs URL: [%s]", pingURLString), (Throwable)e);
        }
    }
}

