/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls2.internal;

import com.xpn.xwiki.util.AbstractXWikiRunnable;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.activeinstalls2.ActiveInstallsConfiguration;
import org.xwiki.activeinstalls2.internal.PingSender;

public class ActiveInstallsPingRunnable
extends AbstractXWikiRunnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveInstallsPingRunnable.class);
    private static final long WAIT_TIME_RETRY = 3000L;
    private static final long RETRIES = 3L;
    private PingSender manager;
    private ActiveInstallsConfiguration configuration;
    private long retryTimeout;
    private long period;
    private TimeUnit timeUnit;

    public ActiveInstallsPingRunnable(ActiveInstallsConfiguration configuration, PingSender manager, long period, TimeUnit timeUnit) {
        this.configuration = configuration;
        this.manager = manager;
        this.period = period;
        this.timeUnit = timeUnit;
    }

    protected void runInternal() throws InterruptedException {
        this.sendPing();
    }

    void sendPing() throws InterruptedException {
        int count = 1;
        while ((long)count <= 3L) {
            try {
                this.manager.sendPing();
                break;
            }
            catch (Exception e) {
                String message = String.format("Failed to send Active Installation ping to [%s] (try [%s]). Error = [%s].", this.configuration.getPingInstanceURL(), count, ExceptionUtils.getRootCauseMessage((Throwable)e));
                if ((long)count == 3L) {
                    message = String.format("%s Will retry in [%s %s]...", message, this.period, this.timeUnit.toString().toLowerCase(Locale.ROOT));
                }
                LOGGER.warn(message);
                if ((long)count < 3L) {
                    Thread.sleep(this.getRetryTimeout());
                }
                ++count;
            }
        }
    }

    void setRetryTimeout(long milliseconds) {
        this.retryTimeout = milliseconds;
    }

    private long getRetryTimeout() {
        return this.retryTimeout > -1L ? this.retryTimeout : 3000L;
    }
}

