/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls2.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.xwiki.activeinstalls2.ActiveInstallsConfiguration;
import org.xwiki.activeinstalls2.internal.ActiveInstallsPingRunnable;
import org.xwiki.activeinstalls2.internal.PingSender;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.context.Execution;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="ActiveInstalls2InitializerListener")
public class ActiveInstallsInitializerListener
implements EventListener,
Initializable,
Disposable {
    private static final long PERIOD = 1L;
    private static final TimeUnit TIME_UNIT = TimeUnit.DAYS;
    private static final List<Event> EVENTS = new ArrayList<ApplicationReadyEvent>(Arrays.asList(new ApplicationReadyEvent()));
    @Inject
    private Provider<PingSender> pingSenderProvider;
    @Inject
    private ActiveInstallsConfiguration configuration;
    @Inject
    private Execution execution;
    private ScheduledExecutorService executorService;

    public void initialize() {
        if (this.execution.getContext() != null) {
            this.startPingThread();
        }
    }

    public void dispose() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    public String getName() {
        return "ActiveInstalls2InitializerListener";
    }

    public void onEvent(Event event, Object source, Object data) {
        this.startPingThread();
    }

    private synchronized void startPingThread() {
        if (this.executorService == null) {
            BasicThreadFactory factory = BasicThreadFactory.builder().namingPattern("Active Installs 2 Ping Thread").daemon(true).priority(1).build();
            ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor((ThreadFactory)factory);
            ActiveInstallsPingRunnable runnable = new ActiveInstallsPingRunnable(this.configuration, (PingSender)this.pingSenderProvider.get(), 1L, TIME_UNIT);
            service.scheduleAtFixedRate((Runnable)((Object)runnable), 0L, 1L, TIME_UNIT);
            this.executorService = service;
        }
    }
}

