/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.tools;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class URLTool {
    public Map<String, List<String>> parseQuery(String query) {
        LinkedHashMap<String, List<String>> queryParams = new LinkedHashMap<String, List<String>>();
        if (query != null) {
            for (NameValuePair params : URLEncodedUtils.parse((String)query, (Charset)StandardCharsets.UTF_8)) {
                String name = params.getName();
                ArrayList<String> values = (ArrayList<String>)queryParams.get(name);
                if (values == null) {
                    values = new ArrayList<String>();
                    queryParams.put(name, values);
                }
                values.add(params.getValue());
            }
        }
        return queryParams;
    }

    public URL toURL(String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

