/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.tools;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import net.sf.json.JSON;
import net.sf.json.JSONException;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONTool.class);
    private static final CustomCharacterEscapes CHARACTER_ESCAPES = new CustomCharacterEscapes();

    public String serialize(Object object) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.getFactory().setCharacterEscapes((CharacterEscapes)CHARACTER_ESCAPES);
            SimpleModule m = new SimpleModule("org.json.* serializer", new Version(1, 0, 0, "", "org.json", "json"));
            m.addSerializer(JSONObject.class, (JsonSerializer)new JSONObjectSerializer());
            m.addSerializer(JSONArray.class, (JsonSerializer)new JSONArraySerializer());
            mapper.registerModule((Module)m);
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to serialize object to JSON", (Throwable)e);
            return null;
        }
    }

    public Object fromString(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return objectMapper.readValue(str, Object.class);
            }
            catch (Exception e) {
                LOGGER.info("Failed to parse JSON [{}]: {}", (Object)StringUtils.abbreviate((String)str, (int)32), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                return null;
            }
        }
        return null;
    }

    @Deprecated
    public JSON parse(String json) {
        try {
            return JSONSerializer.toJSON((Object)json);
        }
        catch (JSONException e) {
            LOGGER.warn("Tried to parse invalid JSON [{}]. Root error: [{}]", (Object)StringUtils.abbreviate((String)json, (int)32), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    private static class CustomCharacterEscapes
    extends CharacterEscapes {
        private static final SerializedString ESCAPED_LEFT_CURLY = new SerializedString("\\u007B");
        private static final SerializedString ESCAPED_LT = new SerializedString("\\u003C");
        private final int[] asciiEscapes = CustomCharacterEscapes.standardAsciiEscapesForJSON();

        CustomCharacterEscapes() {
            this.asciiEscapes[47] = 47;
            this.asciiEscapes[123] = -2;
            this.asciiEscapes[60] = -2;
        }

        public int[] getEscapeCodesForAscii() {
            return this.asciiEscapes;
        }

        public SerializableString getEscapeSequence(int i) {
            return switch (i) {
                case 123 -> ESCAPED_LEFT_CURLY;
                case 60 -> ESCAPED_LT;
                default -> null;
            };
        }
    }

    class JSONObjectSerializer
    extends JsonSerializer<JSONObject> {
        JSONObjectSerializer() {
        }

        public void serialize(JSONObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeRawValue(value.toString());
        }
    }

    class JSONArraySerializer
    extends JsonSerializer<JSONArray> {
        JSONArraySerializer() {
        }

        public void serialize(JSONArray value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeRawValue(value.toString());
        }
    }
}

