/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.properties.converter.collection;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.properties.ConverterManager;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;

public abstract class AbstractCollectionConverter<T extends Collection>
extends AbstractConverter<T> {
    protected static final char QUOTECHAR = '\"';
    protected static final String QUOTESTRING = "\"";
    @Inject
    private ConverterManager converterManager;
    private String delimiters = ", ";

    public ConverterManager getConverterManager() {
        return this.converterManager;
    }

    public void setDelimiters(String delimiter) {
        this.delimiters = delimiter;
    }

    public String getDelimiters() {
        return this.delimiters;
    }

    @Override
    protected <G extends T> G convertToType(Type targetType, Object value) {
        Type elementType = null;
        if (targetType instanceof ParameterizedType) {
            elementType = ((ParameterizedType)targetType).getActualTypeArguments()[0];
        }
        if (value instanceof Iterable) {
            return this.fromIterable(targetType, (Iterable)value, elementType);
        }
        if (value.getClass().isArray()) {
            return this.fromArray(targetType, value, elementType);
        }
        return this.parseElements(targetType, value.toString(), elementType);
    }

    protected <G extends T> G fromIterable(Type targetType, Iterable<?> values, Type elementType) {
        T collection = this.newCollection(targetType);
        for (Object value : values) {
            collection.add(this.converterManager.convert(elementType, value));
        }
        return (G)collection;
    }

    protected <G extends T> G fromArray(Type targetType, Object values, Type elementType) {
        T collection = this.newCollection(targetType);
        for (int i = 0; i < Array.getLength(values); ++i) {
            Object value = Array.get(values, i);
            collection.add(this.converterManager.convert(elementType, value));
        }
        return (G)collection;
    }

    protected <G extends T> G parseElements(Type targetType, String value, Type elementType) {
        String cleanedValue = this.cleanValue(value);
        try {
            int ttype;
            StreamTokenizer st = this.createStreamTokenizer(cleanedValue);
            T collection = this.newCollection(targetType);
            while ((ttype = st.nextToken()) == -3 || ttype > 0) {
                if (st.sval == null) continue;
                String objValue = st.sval;
                if (elementType != null && elementType != String.class) {
                    objValue = this.converterManager.convert(elementType, objValue);
                }
                collection.add((String)objValue);
            }
            if (ttype != -1) {
                throw new ConversionException("Encountered token of type " + ttype + " parsing elements.");
            }
            return (G)collection;
        }
        catch (IOException e) {
            throw new ConversionException("Error converting from String: " + e.getMessage(), e);
        }
    }

    protected <G extends T> T newCollection(Type targetType) {
        Class targetClass = ReflectionUtils.getTypeClass((Type)targetType);
        if (targetClass.isAssignableFrom(ArrayList.class)) {
            return (T)new ArrayList();
        }
        try {
            return (T)((Collection)targetClass.newInstance());
        }
        catch (Exception e) {
            throw new ConversionException("Failed to create new instance of target type [" + String.valueOf(targetType) + "]", e);
        }
    }

    private String cleanValue(String value) {
        String cleanedValue = value.trim();
        if (cleanedValue.startsWith("{") && cleanedValue.endsWith("}")) {
            cleanedValue = cleanedValue.substring(1, cleanedValue.length() - 1);
        }
        return cleanedValue;
    }

    protected StreamTokenizer createStreamTokenizer(String value) {
        StreamTokenizer st = new StreamTokenizer(new StringReader(value));
        st.ordinaryChars(0, 255);
        st.wordChars(0, 255);
        st.quoteChar(34);
        st.quoteChar(39);
        for (char c : this.getDelimiters().toCharArray()) {
            st.whitespaceChars(c, c);
        }
        return st;
    }

    @Override
    public <G> G convert(Type targetType, Object sourceValue) {
        if (targetType == String.class && sourceValue.getClass().isArray()) {
            return (G)this.convertArrayToString(sourceValue);
        }
        return super.convert(targetType, sourceValue);
    }

    protected void convertToString(Object element, StringBuilder sb) {
        String elementString;
        if (sb.length() > 0) {
            sb.append(this.getDelimiters());
        }
        if ((elementString = (String)this.getConverterManager().convert((Type)((Object)String.class), element)) != null) {
            boolean containsDelimiter = StringUtils.containsAny((CharSequence)elementString, (CharSequence)this.getDelimiters());
            if (containsDelimiter) {
                sb.append(QUOTESTRING);
            }
            sb.append(elementString.replace("\\", "\\\\").replace(QUOTESTRING, "\\\"").replace("'", "\\'"));
            if (containsDelimiter) {
                sb.append(QUOTESTRING);
            }
        }
    }

    private String convertArrayToString(Object value) {
        StringBuilder sb = new StringBuilder();
        int lenght = Array.getLength(value);
        for (int i = 0; i < lenght; ++i) {
            this.convertToString(Array.get(value, i), sb);
        }
        return sb.toString();
    }

    @Override
    protected String convertToString(T value) {
        StringBuilder sb = new StringBuilder();
        for (Object element : value) {
            this.convertToString(element, sb);
        }
        return sb.toString();
    }
}

