/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.observation.internal;

import java.util.ArrayDeque;
import java.util.Deque;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.AllEvent;
import org.xwiki.observation.event.BeginEvent;
import org.xwiki.observation.event.EndEvent;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="ObservationContextListener")
public class ObservationContextListener
extends AbstractEventListener {
    @Inject
    private Execution execution;
    @Inject
    private Logger logger;

    public ObservationContextListener() {
        super("ObservationContextListener", new Event[]{AllEvent.ALLEVENT});
    }

    private Deque<BeginEvent> getCurrentEvents() {
        Deque events = null;
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            events = (Deque)context.getProperty("observation.currentevents");
        }
        return events;
    }

    private void pushCurrentEvent(BeginEvent event) {
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            ArrayDeque<BeginEvent> events = (ArrayDeque<BeginEvent>)context.getProperty("observation.currentevents");
            if (events == null) {
                events = new ArrayDeque<BeginEvent>();
                context.newProperty("observation.currentevents").initial(events).inherited().makeFinal().declare();
            }
            events.push(event);
        }
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof BeginEvent) {
            this.pushCurrentEvent((BeginEvent)event);
        } else if (event instanceof EndEvent) {
            Deque<BeginEvent> events = this.getCurrentEvents();
            if (events != null && !events.isEmpty()) {
                events.pop();
            } else {
                this.logger.error("Can't find any begin event corresponding to [{}]", (Object)event);
            }
        }
    }
}

