/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.observation.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.collection.internal.PriorityEntries;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.event.ComponentDescriptorAddedEvent;
import org.xwiki.component.event.ComponentDescriptorEvent;
import org.xwiki.component.event.ComponentDescriptorRemovedEvent;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.AllEvent;
import org.xwiki.observation.event.Event;

@Component
@Singleton
public class DefaultObservationManager
implements ObservationManager {
    private volatile Map<Class<? extends Event>, PriorityEntries<RegisteredListener>> listenersByEvent;
    private volatile Map<String, EventListener> listenersByName;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    private Map<Class<? extends Event>, PriorityEntries<RegisteredListener>> getListenersByEvent() {
        if (this.listenersByEvent == null) {
            this.initializeListeners();
        }
        return this.listenersByEvent;
    }

    private Map<String, EventListener> getListenersByName() {
        if (this.listenersByName == null) {
            this.initializeListeners();
        }
        return this.listenersByName;
    }

    private synchronized void initializeListeners() {
        if (this.listenersByName == null) {
            this.listenersByEvent = new ConcurrentHashMap<Class<? extends Event>, PriorityEntries<RegisteredListener>>();
            this.listenersByName = new ConcurrentHashMap<String, EventListener>();
            if (this.componentManager != null) {
                for (ComponentDescriptor descriptor : this.componentManager.getComponentDescriptorList(EventListener.class)) {
                    try {
                        this.addListener((EventListener)this.componentManager.getInstance(EventListener.class, descriptor.getRoleHint()), descriptor.getRoleTypePriority());
                    }
                    catch (ComponentLookupException e) {
                        this.logger.error("Failed to lookup listener with role hint [{}]", (Object)descriptor.getRoleHint(), (Object)e);
                    }
                }
            }
        }
    }

    public void addListener(EventListener eventListener) {
        this.addListener(eventListener, 1000);
    }

    public void addListener(EventListener eventListener, int priority) {
        try {
            this.addListenerInternal(eventListener, priority);
        }
        catch (Exception e) {
            this.logger.warn("Failed to add listener. Root cause: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListenerInternal(EventListener eventListener, int priority) {
        Map<String, EventListener> listeners = this.getListenersByName();
        EventListener previousListener = listeners.get(eventListener.getName());
        if (previousListener != null) {
            this.removeListener(eventListener.getName());
            this.logger.warn("The [{}] listener is overwriting a previously registered listener [{}] since they both are registered under the same id [{}]. In the future consider removing a Listener first if you really want to register it again.", new Object[]{eventListener.getClass().getName(), previousListener.getClass().getName(), eventListener.getName()});
        }
        listeners.put(eventListener.getName(), eventListener);
        Map<Class<? extends Event>, PriorityEntries<RegisteredListener>> map = this.listenersByEvent;
        synchronized (map) {
            for (Event event : eventListener.getEvents()) {
                PriorityEntries eventListeners = this.listenersByEvent.get(event.getClass());
                if (eventListeners == null) {
                    eventListeners = new PriorityEntries();
                    this.listenersByEvent.put(event.getClass(), (PriorityEntries<RegisteredListener>)eventListeners);
                    eventListeners.put(eventListener.getName(), (Comparable)new RegisteredListener(eventListener, event, priority));
                    continue;
                }
                RegisteredListener registeredListener = (RegisteredListener)eventListeners.get(eventListener.getName());
                if (registeredListener == null) {
                    eventListeners.put(eventListener.getName(), (Comparable)new RegisteredListener(eventListener, event, priority));
                    continue;
                }
                registeredListener.addEvent(event);
            }
        }
    }

    public void removeListener(String listenerName) {
        this.getListenersByName().remove(listenerName);
        for (Map.Entry<Class<? extends Event>, PriorityEntries<RegisteredListener>> entry : this.listenersByEvent.entrySet()) {
            entry.getValue().remove(listenerName);
            if (!entry.getValue().isEmpty()) continue;
            this.listenersByEvent.remove(entry.getKey());
        }
    }

    public void addEvent(String listenerName, Event event) {
        PriorityEntries listeners = this.getListenersByEvent().computeIfAbsent(event.getClass(), k -> new PriorityEntries());
        RegisteredListener listener = (RegisteredListener)listeners.get(listenerName);
        if (listener != null) {
            listener.addEvent(event);
        } else {
            listeners.put(listenerName, (Comparable)new RegisteredListener(this.getListener(listenerName), event, 1000));
        }
    }

    public void removeEvent(String listenerName, Event event) {
        RegisteredListener listener;
        PriorityEntries<RegisteredListener> listeners = this.getListenersByEvent().get(event.getClass());
        if (listeners != null && (listener = (RegisteredListener)listeners.get(listenerName)) != null) {
            listener.removeEvent(event);
        }
    }

    public EventListener getListener(String listenerName) {
        return this.getListenersByName().get(listenerName);
    }

    public void notify(Event event, Object source, Object data) {
        PriorityEntries<RegisteredListener> allEventRegListeners;
        PriorityEntries<RegisteredListener> regListeners = this.getListenersByEvent().get(event.getClass());
        if (regListeners != null) {
            this.notify(regListeners.getSorted(), event, source, data);
        }
        if ((allEventRegListeners = this.listenersByEvent.get(AllEvent.class)) != null) {
            this.notify(allEventRegListeners.getSorted(), event, source, data);
        }
        if (event instanceof ComponentDescriptorEvent) {
            this.onComponentEvent((ComponentDescriptorEvent)event, (ComponentManager)source, (ComponentDescriptor<EventListener>)((ComponentDescriptor)data));
        }
    }

    private void notify(Collection<RegisteredListener> listeners, Event event, Object source, Object data) {
        block2: for (RegisteredListener listener : listeners) {
            for (Event listenerEvent : listener.events) {
                if (!listenerEvent.matches((Object)event)) continue;
                try {
                    listener.listener.onEvent(event, source, data);
                }
                catch (Exception | LinkageError e) {
                    this.logger.error("Failed to send event [{}] to listener [{}]", new Object[]{event, listener.listener, e});
                }
                continue block2;
            }
        }
    }

    public void notify(Event event, Object source) {
        this.notify(event, source, null);
    }

    private void onComponentEvent(ComponentDescriptorEvent componentEvent, ComponentManager componentManager, ComponentDescriptor<EventListener> descriptor) {
        try {
            if (componentEvent.getRoleType() == EventListener.class) {
                if (componentEvent instanceof ComponentDescriptorAddedEvent) {
                    this.onEventListenerComponentAdded((ComponentDescriptorAddedEvent)componentEvent, componentManager, descriptor);
                } else if (componentEvent instanceof ComponentDescriptorRemovedEvent) {
                    this.onEventListenerComponentRemoved((ComponentDescriptorRemovedEvent)componentEvent, componentManager, descriptor);
                } else {
                    this.logger.warn("Ignoring unknown Component event [{}]", (Object)componentEvent.getClass().getName());
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to notify some event listeners about component [{}] being added or removed. Root cause: [{}]", descriptor, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private void onEventListenerComponentAdded(ComponentDescriptorAddedEvent event, ComponentManager componentManager, ComponentDescriptor<EventListener> descriptor) {
        try {
            EventListener eventListener = (EventListener)componentManager.getInstance(EventListener.class, event.getRoleHint());
            EventListener existingListener = this.getListener(eventListener.getName());
            if (existingListener != eventListener) {
                this.addListener(eventListener, descriptor.getRoleTypePriority());
            }
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup the Event Listener [{}] corresponding to the Component registration event for [{}]. Ignoring the event", new Object[]{event.getRoleHint(), descriptor.getImplementation().getName(), e});
        }
    }

    private void onEventListenerComponentRemoved(ComponentDescriptorRemovedEvent event, ComponentManager componentManager, ComponentDescriptor<?> descriptor) {
        EventListener removedEventListener = null;
        for (EventListener eventListener : this.getListenersByName().values()) {
            if (eventListener.getClass() != descriptor.getImplementation()) continue;
            removedEventListener = eventListener;
        }
        if (removedEventListener != null) {
            this.removeListener(removedEventListener.getName());
        }
    }

    private static class RegisteredListener
    implements Comparable<RegisteredListener> {
        private List<Event> events = new ArrayList<Event>();
        private EventListener listener;
        private int priority;

        RegisteredListener(EventListener listener, Event event, int priority) {
            this.addEvent(event);
            this.listener = listener;
            this.priority = priority;
        }

        void addEvent(Event event) {
            this.events.add(event);
        }

        void removeEvent(Event event) {
            this.events.remove(event);
        }

        @Override
        public int compareTo(RegisteredListener other) {
            return this.priority - other.priority;
        }
    }
}

