/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.properties.converter;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.properties.ConverterManager;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;

@Deprecated
public abstract class AbstractCollectionConverter
extends AbstractConverter {
    protected static final char QUOTECHAR = '\"';
    protected static final String QUOTESTRING = "\"";
    @Inject
    private ConverterManager converterManager;
    private String delimiters = ", ";

    public ConverterManager getConverterManager() {
        return this.converterManager;
    }

    public void setDelimiters(String delimiter) {
        this.delimiters = delimiter;
    }

    public String getDelimiters() {
        return this.delimiters;
    }

    protected Object convertToType(Type targetType, Object value) {
        Type genericType = null;
        if (targetType instanceof ParameterizedType) {
            genericType = ((ParameterizedType)targetType).getActualTypeArguments()[0];
        }
        return this.parseElements(value.toString(), genericType);
    }

    protected Collection parseElements(String value, Type genericType) {
        String cleanedValue = this.cleanValue(value);
        try {
            int ttype;
            StreamTokenizer st = this.createStreamTokenizer(cleanedValue);
            Collection collection = this.newCollection();
            while ((ttype = st.nextToken()) == -3 || ttype > 0) {
                if (st.sval == null) continue;
                Object objValue = st.sval;
                if (genericType != null && genericType != String.class) {
                    objValue = this.converterManager.convert(genericType, objValue);
                }
                collection.add(objValue);
            }
            if (ttype != -1) {
                throw new ConversionException("Encountered token of type " + ttype + " parsing elements.");
            }
            return collection;
        }
        catch (IOException e) {
            throw new ConversionException("Error converting from String: " + e.getMessage(), (Throwable)e);
        }
    }

    protected Collection newCollection() {
        return new ArrayList();
    }

    private String cleanValue(String value) {
        String cleanedValue = value.trim();
        if (cleanedValue.startsWith("{") && cleanedValue.endsWith("}")) {
            cleanedValue = cleanedValue.substring(1, cleanedValue.length() - 1);
        }
        return cleanedValue;
    }

    protected StreamTokenizer createStreamTokenizer(String value) {
        StreamTokenizer st = new StreamTokenizer(new StringReader(value));
        st.ordinaryChars(0, 255);
        st.wordChars(0, 255);
        st.quoteChar(34);
        st.quoteChar(39);
        for (char c : this.getDelimiters().toCharArray()) {
            st.whitespaceChars(c, c);
        }
        return st;
    }

    protected String convertToString(Object value) {
        StringBuilder sb = new StringBuilder();
        Collection collection = (Collection)value;
        for (Object element : collection) {
            String elementString;
            if (sb.length() > 0) {
                sb.append(this.getDelimiters());
            }
            if ((elementString = (String)this.getConverterManager().convert(String.class, element)) == null) continue;
            boolean containsDelimiter = StringUtils.contains((CharSequence)elementString, (CharSequence)this.getDelimiters());
            if (containsDelimiter) {
                sb.append(QUOTESTRING);
            }
            sb.append(elementString.replace("\\", "\\\\").replace(QUOTESTRING, "\\\"").replace("'", "\\'"));
            if (!containsDelimiter) continue;
            sb.append(QUOTESTRING);
        }
        return sb.toString();
    }

    @Deprecated
    public char getDelimiter() {
        return this.delimiters.charAt(0);
    }

    @Deprecated
    public void setAllowedChars(char[] allowedChars) {
    }

    @Deprecated
    public void setDelimiter(char delimiter) {
        this.setDelimiters(String.valueOf(delimiter));
    }
}

