/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.classloader.ClassLoaderManager;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.job.GroupedJob;
import org.xwiki.job.GroupedJobInitializer;
import org.xwiki.job.GroupedJobInitializerManager;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.JobGroupPath;
import org.xwiki.job.JobManagerConfiguration;
import org.xwiki.job.Request;
import org.xwiki.job.internal.JobGroupPathLockTree;

@Component
@Singleton
public class DefaultJobExecutor
implements JobExecutor,
Initializable,
Disposable {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManager;
    @Inject
    private JobManagerConfiguration jobManagerConfiguration;
    @Inject
    private GroupedJobInitializerManager groupedJobInitializerManager;
    @Inject
    private ClassLoaderManager classloaderManager;
    private final Map<List<String>, Queue<Job>> groupedJobs = new ConcurrentHashMap<List<String>, Queue<Job>>();
    private final Map<List<String>, Job> jobs = new ConcurrentHashMap<List<String>, Job>();
    @Inject
    private JobGroupPathLockTree lockTree;
    private final Map<JobGroupPath, JobGroupExecutor> groupExecutors = new ConcurrentHashMap<JobGroupPath, JobGroupExecutor>();
    private JobThreadExecutor jobExecutor;
    private volatile boolean disposed;

    public void initialize() throws InitializationException {
        this.jobExecutor = new JobThreadExecutor(0, Integer.MAX_VALUE, this.jobManagerConfiguration.getSingleJobThreadKeepAliveTime(), TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws ComponentLifecycleException {
        DefaultJobExecutor defaultJobExecutor = this;
        synchronized (defaultJobExecutor) {
            this.disposed = true;
            this.jobExecutor.shutdownNow();
            for (JobGroupExecutor executor : this.groupExecutors.values()) {
                executor.shutdownNow();
            }
        }
    }

    public Job getCurrentJob(JobGroupPath path) {
        JobGroupExecutor executor = this.groupExecutors.get(path);
        return executor != null ? executor.currentJob : null;
    }

    public Job getJob(List<String> id) {
        Job job = this.jobs.get(id);
        if (job != null) {
            return job;
        }
        Queue<Job> jobQueue = this.groupedJobs.get(id);
        if (jobQueue != null && (job = jobQueue.peek()) != null) {
            return job;
        }
        return null;
    }

    private Job createJob(String jobType, Request request) throws JobException {
        Job job;
        try {
            job = (Job)((ComponentManager)this.componentManager.get()).getInstance(Job.class, jobType);
        }
        catch (ComponentLookupException e) {
            throw new JobException("Failed to lookup any Job for role hint [" + jobType + "]", (Throwable)e);
        }
        job.initialize(request);
        return job;
    }

    public Job execute(String jobType, Request request) throws JobException {
        Job job = this.createJob(jobType, request);
        this.execute(job);
        return job;
    }

    public void execute(Job job) {
        if (!this.disposed) {
            if (job instanceof GroupedJob) {
                this.executeGroupedJob((GroupedJob)job);
            } else {
                this.executeSingleJob(job);
            }
        } else {
            throw new RejectedExecutionException("The job executor is disposed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSingleJob(Job job) {
        this.jobExecutor.execute((Runnable)job);
        List jobId = job.getRequest().getId();
        if (jobId != null) {
            Map<List<String>, Job> map = this.jobs;
            synchronized (map) {
                this.jobs.put(jobId, job);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeGroupedJob(GroupedJob job) {
        Map<JobGroupPath, JobGroupExecutor> map = this.groupExecutors;
        synchronized (map) {
            JobGroupPath path = job.getGroupPath();
            if (path == null) {
                this.executeSingleJob((Job)job);
                return;
            }
            JobGroupExecutor groupExecutor = this.groupExecutors.get(path);
            if (groupExecutor == null) {
                groupExecutor = new JobGroupExecutor(path, this.groupedJobInitializerManager.getGroupedJobInitializer(path));
                this.groupExecutors.put(path, groupExecutor);
            }
            groupExecutor.execute((Runnable)job);
            List jobId = job.getRequest().getId();
            if (jobId != null) {
                Map<List<String>, Queue<Job>> map2 = this.groupedJobs;
                synchronized (map2) {
                    Queue<Job> jobQueue = this.groupedJobs.get(jobId);
                    if (jobQueue == null) {
                        jobQueue = new ConcurrentLinkedQueue<Job>();
                        this.groupedJobs.put(jobId, jobQueue);
                    }
                    jobQueue.offer((Job)job);
                }
            }
        }
    }

    private class JobThreadExecutor
    extends ThreadPoolExecutor {
        JobThreadExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }

        protected String getThreadName(Runnable r) {
            return r.toString();
        }

        protected String getExecutorThreadName(Runnable r) {
            return "Unused job pool thread";
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            Thread.currentThread().setName(this.getThreadName(r));
            Thread.currentThread().setContextClassLoader((ClassLoader)DefaultJobExecutor.this.classloaderManager.getURLClassLoader(null, false));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            Job job = (Job)r;
            List jobId = job.getRequest().getId();
            if (jobId != null) {
                Map<List<String>, Job> map = DefaultJobExecutor.this.jobs;
                synchronized (map) {
                    Job storedJob = DefaultJobExecutor.this.jobs.get(jobId);
                    if (storedJob == job) {
                        DefaultJobExecutor.this.jobs.remove(jobId);
                    }
                }
            }
            Thread.currentThread().setName(this.getExecutorThreadName(r));
        }
    }

    private class JobGroupExecutor
    extends JobThreadExecutor
    implements ThreadFactory {
        private final ThreadFactory threadFactory;
        private final JobGroupPath path;
        private Job currentJob;
        private String groupThreadName;
        private GroupedJobInitializer initializer;

        JobGroupExecutor(JobGroupPath path, GroupedJobInitializer initializer) {
            super(initializer.getPoolSize(), initializer.getPoolSize(), DefaultJobExecutor.this.jobManagerConfiguration.getGroupedJobThreadKeepAliveTime(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            this.threadFactory = Executors.defaultThreadFactory();
            this.allowCoreThreadTimeOut(true);
            this.initializer = initializer;
            this.setThreadFactory(this);
            this.path = path;
            this.groupThreadName = String.valueOf(this.path) + " job group daemon thread";
        }

        @Override
        protected String getThreadName(Runnable r) {
            return this.groupThreadName + " - " + String.valueOf(this.currentJob);
        }

        @Override
        protected String getExecutorThreadName(Runnable r) {
            return this.groupThreadName;
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            DefaultJobExecutor.this.lockTree.lock(this.path);
            this.currentJob = (Job)r;
            super.beforeExecute(t, r);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            DefaultJobExecutor.this.lockTree.unlock(this.path);
            this.currentJob = null;
            super.afterExecute(r, t);
            Job job = (Job)r;
            List jobId = job.getRequest().getId();
            if (jobId != null) {
                Map<List<String>, Queue<Job>> map = DefaultJobExecutor.this.groupedJobs;
                synchronized (map) {
                    Queue<Job> jobQueue = DefaultJobExecutor.this.groupedJobs.get(jobId);
                    if (jobQueue != null && jobQueue.peek() == job) {
                        jobQueue.poll();
                    }
                }
            }
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.threadFactory.newThread(r);
            thread.setDaemon(true);
            thread.setName(this.groupThreadName);
            thread.setPriority(this.initializer.getDefaultPriority());
            return thread;
        }
    }
}

