/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.util.Deque;
import java.util.LinkedList;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.job.Job;
import org.xwiki.job.JobContext;

@Component
@Singleton
public class DefaultJobContext
implements JobContext {
    private static final String KEY_CURRENTJOB = "job.current";
    @Inject
    private Execution execution;

    private Deque<Job> getJobstack(boolean create) {
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            LinkedList stack = (LinkedList)context.getProperty(KEY_CURRENTJOB);
            if (stack == null && create) {
                stack = new LinkedList();
                context.setProperty(KEY_CURRENTJOB, stack);
            }
            return stack;
        }
        return null;
    }

    public Job getCurrentJob() {
        Deque<Job> stack = this.getJobstack(false);
        return stack == null || stack.isEmpty() ? null : stack.peek();
    }

    public void pushCurrentJob(Job job) {
        Deque<Job> stack = this.getJobstack(true);
        if (stack != null) {
            stack.push(job);
        }
    }

    public void popCurrentJob() {
        Deque<Job> stack = this.getJobstack(false);
        if (stack != null) {
            stack.pop();
        }
    }
}

