/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.io.File;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.inject.Inject;
import org.xwiki.job.JobManagerConfiguration;
import org.xwiki.job.internal.JobStatusFolderResolver;

public abstract class AbstractJobStatusFolderResolver
implements JobStatusFolderResolver {
    protected static final String FOLDER_NULL = "&null";
    @Inject
    protected JobManagerConfiguration configuration;

    @Override
    public File getFolder(List<String> id) {
        File folder = this.getBaseFolder();
        if (id != null) {
            for (String fullIdElement : id) {
                folder = this.addIDElement(fullIdElement, folder);
            }
        }
        return folder;
    }

    protected String nullAwareURLEncode(String value) {
        String encoded = value != null ? URLEncoder.encode(value, StandardCharsets.UTF_8) : FOLDER_NULL;
        return encoded;
    }

    protected File getBaseFolder() {
        return this.configuration.getStorage();
    }

    protected abstract File addIDElement(String var1, File var2);
}

