/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.jakartabridge.internal;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import org.xwiki.jakartabridge.JakartaBridge;
import org.xwiki.jakartabridge.internal.AbstractJavaxToJakartaWrapper;

public class JavaxToJakartaCollection<C extends Collection<K>, X, K>
extends AbstractJavaxToJakartaWrapper<C>
implements Collection<X> {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    protected final Function<K, X> javaxProvider;
    protected final Function<X, K> jakartaProvider;

    public JavaxToJakartaCollection(C wrapped, Function<K, X> javaxProvider, Function<X, K> jakartaProvider) {
        super(wrapped);
        this.javaxProvider = javaxProvider;
        this.jakartaProvider = jakartaProvider;
    }

    @Override
    public int size() {
        return ((Collection)this.getJakarta()).size();
    }

    @Override
    public boolean isEmpty() {
        return ((Collection)this.getJakarta()).isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return ((Collection)this.getJakarta()).contains(this.jakartaProvider.apply(o));
    }

    @Override
    public Iterator<X> iterator() {
        return JakartaBridge.toJavax(((Collection)this.getJakarta()).iterator(), this.javaxProvider, this.jakartaProvider);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(EMPTY_OBJECT_ARRAY);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] jakartaArray = ((Collection)this.getJakarta()).toArray();
        if (jakartaArray.length == 0) {
            return a;
        }
        Object[] javaxArray = (Object[])Array.newInstance(a.getClass().getComponentType(), jakartaArray.length);
        for (int i = 0; i < jakartaArray.length; ++i) {
            Object jakartaObject = jakartaArray[i];
            javaxArray[i] = jakartaObject != null ? this.javaxProvider.apply(jakartaObject) : null;
        }
        return javaxArray;
    }

    @Override
    public boolean add(X e) {
        return ((Collection)this.getJakarta()).add(this.jakartaProvider.apply(e));
    }

    @Override
    public boolean remove(Object o) {
        return ((Collection)this.getJakarta()).remove(this.jakartaProvider.apply(o));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return ((Collection)this.getJakarta()).containsAll(JakartaBridge.toJakarta(c, this.javaxProvider, this.jakartaProvider));
    }

    @Override
    public boolean addAll(Collection<? extends X> c) {
        return ((Collection)this.getJakarta()).addAll(JakartaBridge.toJakarta(c, this.javaxProvider, this.jakartaProvider));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return ((Collection)this.getJakarta()).retainAll(JakartaBridge.toJakarta(c, this.javaxProvider, this.jakartaProvider));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return ((Collection)this.getJakarta()).removeAll(JakartaBridge.toJakarta(c, this.javaxProvider, this.jakartaProvider));
    }

    @Override
    public void clear() {
        ((Collection)this.getJakarta()).clear();
    }
}

