/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xml.internal.parameter;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.core.MapBackedDataHolder;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomReader;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.thoughtworks.xstream.io.xml.StaxWriter;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.filter.xml.internal.XMLUtils;
import org.xwiki.filter.xml.internal.parameter.ParameterManager;
import org.xwiki.filter.xml.internal.parameter.ParameterXStream;

@Component
@Singleton
public class XStreamParameterManager
implements ParameterManager,
Initializable {
    public static final String DDEFAULTTYPE_NAME = "defaultType";
    @Inject
    private Logger logger;
    private XStream xstream;
    private StaxDriver staxDriver;

    public void initialize() throws InitializationException {
        this.staxDriver = new StaxDriver();
        this.xstream = new ParameterXStream((HierarchicalStreamDriver)this.staxDriver);
    }

    @Override
    public void serialize(Type type, Object object, XMLStreamWriter xmlStreamWriter) {
        StaxWriter staxWriter;
        Class typeClass = ReflectionUtils.getTypeClass((Type)type);
        if (typeClass != null && Objects.equals(XMLUtils.emptyValue(typeClass), object)) {
            return;
        }
        try {
            staxWriter = this.staxDriver.createStaxWriter(xmlStreamWriter, false);
        }
        catch (XMLStreamException e) {
            this.logger.error("Failed to create new instance of StaxWriter", (Throwable)e);
            return;
        }
        MapBackedDataHolder dataHolder = new MapBackedDataHolder();
        if (type != Object.class) {
            dataHolder.put((Object)DDEFAULTTYPE_NAME, (Object)type);
        }
        this.xstream.marshal(object, (HierarchicalStreamWriter)staxWriter, (DataHolder)dataHolder);
    }

    @Override
    public Object unSerialize(Type type, Element rootElement) throws ClassNotFoundException {
        Object value;
        if (type != null && !rootElement.hasChildNodes() && (value = XMLUtils.emptyValue(ReflectionUtils.getTypeClass((Type)type))) != null) {
            return value;
        }
        MapBackedDataHolder dataHolder = new MapBackedDataHolder();
        if (type == Object.class) {
            dataHolder.put((Object)DDEFAULTTYPE_NAME, String.class);
        } else {
            dataHolder.put((Object)DDEFAULTTYPE_NAME, (Object)type);
        }
        return this.xstream.unmarshal((HierarchicalStreamReader)new DomReader(rootElement), null, (DataHolder)dataHolder);
    }
}

