/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.xml.internal.parameter;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.core.TreeMarshaller;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Type;
import org.xwiki.component.util.ReflectionUtils;

public class XMLTreeMarshaller
extends TreeMarshaller {
    public XMLTreeMarshaller(HierarchicalStreamWriter writer, ConverterLookup converterLookup, Mapper mapper) {
        super(writer, converterLookup, mapper);
    }

    public void start(Object item, DataHolder dataHolder) {
        Type type = (Type)dataHolder.get((Object)"defaultType");
        if (item != null) {
            Converter converter = this.getConverter(type);
            if (converter == null) {
                this.convertAnother(item);
            } else {
                this.convert(item, converter);
            }
        }
    }

    private Converter getConverter(Type type) {
        if (type != null) {
            Class typeClass = ReflectionUtils.getTypeClass((Type)type);
            if (typeClass == null) {
                throw new ConversionException("Can't find any converter for the type [" + String.valueOf(type) + "]");
            }
            Converter converter = this.converterLookup.lookupConverterForType(typeClass);
            if (converter.getClass() != ReflectionConverter.class) {
                return converter;
            }
        }
        return null;
    }
}

