/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.filterxml.internal.input;

import com.ctc.wstx.api.WstxInputProperties;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.UnknownFilter;
import org.xwiki.filter.filterxml.input.FilterXMLInputProperties;
import org.xwiki.filter.filterxml.internal.output.XMLOutputFilterFactory;
import org.xwiki.filter.output.OutputFilterStreamFactory;
import org.xwiki.filter.type.FilterStreamType;
import org.xwiki.filter.xml.internal.input.AbstractXMLBeanInputFilterStreamFactory;
import org.xwiki.filter.xml.parser.XMLParserFactory;

@Component
@Named(value="filter+xml")
@Singleton
public class XMLInputFilterFactory
extends AbstractXMLBeanInputFilterStreamFactory<FilterXMLInputProperties, Object> {
    @Inject
    private XMLParserFactory parserFactory;
    @Inject
    private Provider<ComponentManager> contextComponentManager;

    public XMLInputFilterFactory() {
        super(FilterStreamType.FILTER_XML);
        this.setName("Generic XML input stream");
        this.setDescription("Generates wiki events from generic XML file.");
        this.xmlFactory = XMLInputFactory.newInstance();
        this.xmlFactory.setProperty("com.ctc.wstx.fragmentMode", WstxInputProperties.PARSING_MODE_FRAGMENT);
    }

    public Collection<Class<?>> getFilterInterfaces() throws FilterException {
        List factories;
        try {
            factories = ((ComponentManager)this.contextComponentManager.get()).getInstanceList(OutputFilterStreamFactory.class);
        }
        catch (ComponentLookupException e) {
            throw new FilterException("Failed to lookup OutputFilterFactory components instances", (Throwable)e);
        }
        HashSet filters = new HashSet();
        filters.add(UnknownFilter.class);
        for (OutputFilterStreamFactory factory : factories) {
            if (factory.getClass() == XMLOutputFilterFactory.class) continue;
            filters.addAll(factory.getFilterInterfaces());
        }
        return filters;
    }

    protected XMLEventWriter createXMLEventWriter(Object filter, FilterXMLInputProperties properties) {
        return this.parserFactory.createXMLEventWriter(filter, null);
    }
}

