/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.type;

import java.util.Objects;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.filter.type.SystemType;
import org.xwiki.stability.Unstable;

public class FilterStreamType
implements Comparable<FilterStreamType> {
    public static final String DATA_XML = "xml";
    public static final String DATA_XAR = "xar";
    public static final String DATA_TEXT = "text";
    public static final FilterStreamType FILTER_XML = new FilterStreamType(SystemType.FILTER, "xml");
    public static final FilterStreamType XWIKI_XAR_11 = new FilterStreamType(SystemType.XWIKI, "xar", "1.1");
    public static final FilterStreamType XWIKI_XAR_12 = new FilterStreamType(SystemType.XWIKI, "xar", "1.2");
    public static final FilterStreamType XWIKI_XAR_13 = new FilterStreamType(SystemType.XWIKI, "xar", "1.3");
    public static final FilterStreamType XWIKI_XAR_14 = new FilterStreamType(SystemType.XWIKI, "xar", "1.4");
    public static final FilterStreamType XWIKI_XAR_15 = new FilterStreamType(SystemType.XWIKI, "xar", "1.5");
    @Unstable
    public static final FilterStreamType XWIKI_XAR_16;
    public static final FilterStreamType XWIKI_XAR_CURRENT;
    public static final FilterStreamType XWIKI_INSTANCE;
    public static final FilterStreamType CONFLUENCE_XML;
    public static final FilterStreamType MEDIAWIKI_XML;
    public static final FilterStreamType DOKUWIKI_TEXT;
    private SystemType type;
    private String dataFormat;
    private String version;

    public FilterStreamType(SystemType type, String dataFormat) {
        this(type, dataFormat, null);
    }

    public FilterStreamType(SystemType type, String dataFormat, String version) {
        this.type = type;
        this.dataFormat = dataFormat != null ? dataFormat.toLowerCase() : null;
        this.version = version;
    }

    public SystemType getType() {
        return this.type;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public String getVersion() {
        return this.version;
    }

    public String serialize() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getType().serialize());
        if (this.getDataFormat() != null) {
            builder.append('+');
            builder.append(this.getDataFormat());
        }
        if (this.getVersion() != null) {
            builder.append('/');
            builder.append(this.getVersion());
        }
        return builder.toString();
    }

    public static FilterStreamType unserialize(String str) {
        int dataIndex;
        if (str == null) {
            return null;
        }
        String wikiType = str;
        String data = null;
        String version = null;
        int versionIndex = str.lastIndexOf(47);
        if (versionIndex == 0) {
            throw new IllegalArgumentException("'/' is invalid as first character: " + str);
        }
        if (versionIndex != -1) {
            version = wikiType.substring(versionIndex + 1);
            wikiType = wikiType.substring(0, versionIndex);
        }
        if ((dataIndex = str.indexOf(43)) == 0) {
            throw new IllegalArgumentException("'+' is invalid as first character: " + str);
        }
        if (dataIndex != -1) {
            data = wikiType.substring(dataIndex + 1);
            wikiType = wikiType.substring(0, dataIndex);
        }
        return new FilterStreamType(SystemType.unserialize(wikiType), data, version);
    }

    public String toString() {
        return this.serialize();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getType()).append((Object)this.getDataFormat()).append((Object)this.getVersion()).toHashCode();
    }

    public boolean equals(Object object) {
        boolean result = this == object ? true : (object instanceof FilterStreamType ? Objects.equals(this.getType(), ((FilterStreamType)object).getType()) && Objects.equals(this.getDataFormat(), ((FilterStreamType)object).getDataFormat()) && Objects.equals(this.getVersion(), ((FilterStreamType)object).getVersion()) : false);
        return result;
    }

    @Override
    public int compareTo(FilterStreamType o) {
        CompareToBuilder builder = new CompareToBuilder();
        builder.append((Object)this.getType().toString(), (Object)o.getType().toString());
        builder.append((Object)this.getDataFormat(), (Object)o.getDataFormat());
        builder.append((Object)this.getVersion(), (Object)o.getVersion());
        return builder.toComparison();
    }

    static {
        XWIKI_XAR_CURRENT = XWIKI_XAR_16 = new FilterStreamType(SystemType.XWIKI, DATA_XAR, "1.6");
        XWIKI_INSTANCE = new FilterStreamType(SystemType.XWIKI, "instance");
        CONFLUENCE_XML = new FilterStreamType(SystemType.CONFLUENCE, DATA_XML);
        MEDIAWIKI_XML = new FilterStreamType(SystemType.MEDIAWIKI, DATA_XML);
        DOKUWIKI_TEXT = new FilterStreamType(SystemType.DOKUWIKI, DATA_TEXT);
    }
}

