/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.internal.output;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.output.DefaultFileOutputTarget;
import org.xwiki.filter.output.OutputTarget;
import org.xwiki.filter.output.OutputTargetReferenceParser;
import org.xwiki.filter.output.StringWriterOutputTarget;

@Component
@Singleton
public class DefaultOutputTargetReferenceParser
implements OutputTargetReferenceParser {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;

    @Override
    public OutputTarget parse(String reference) throws FilterException {
        OutputTarget outputTarget;
        if (reference == null) {
            return null;
        }
        int index = reference.indexOf(58);
        if (index > 0) {
            String prefix = reference.substring(0, index);
            String value = reference.substring(index + 1);
            if (prefix.equals("file")) {
                outputTarget = new DefaultFileOutputTarget(new File(value));
            } else {
                ComponentManager componentManager = (ComponentManager)this.contextComponentManagerProvider.get();
                if (componentManager.hasComponent(OutputTargetReferenceParser.class, prefix)) {
                    OutputTargetReferenceParser parser;
                    try {
                        parser = (OutputTargetReferenceParser)componentManager.getInstance(OutputTargetReferenceParser.class, prefix);
                    }
                    catch (ComponentLookupException e) {
                        throw new FilterException("Failed to get the input source reference parser component for prefix [" + prefix + "]", e);
                    }
                    outputTarget = parser.parse(value);
                } else {
                    outputTarget = new StringWriterOutputTarget();
                }
            }
        } else {
            outputTarget = new StringWriterOutputTarget();
        }
        return outputTarget;
    }
}

