/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.internal.input;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.input.DefaultByteArrayInputSource;
import org.xwiki.filter.input.DefaultFileInputSource;
import org.xwiki.filter.input.DefaultInputStreamInputSource;
import org.xwiki.filter.input.DefaultReaderInputSource;
import org.xwiki.filter.input.DefaultURLInputSource;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.input.InputSourceReferenceParser;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;

@Component
@Singleton
public class InputSourceConverter
extends AbstractConverter<InputSource> {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;
    @Inject
    private InputSourceReferenceParser parser;

    protected <G extends InputSource> G convertToType(Type targetType, Object value) {
        InputSource inputSource;
        if (value == null) {
            return null;
        }
        if (value instanceof InputSource) {
            return (G)((InputSource)value);
        }
        if (value instanceof String) {
            inputSource = this.fromString(value.toString());
        } else if (value instanceof InputStream) {
            inputSource = new DefaultInputStreamInputSource((InputStream)value);
        } else if (value instanceof byte[]) {
            inputSource = new DefaultByteArrayInputSource((byte[])value);
        } else if (value instanceof File) {
            inputSource = new DefaultFileInputSource((File)value);
        } else if (value instanceof Reader) {
            inputSource = new DefaultReaderInputSource((Reader)value);
        } else if (value instanceof URL) {
            inputSource = new DefaultURLInputSource((URL)value);
        } else {
            ParameterizedType componentRole = TypeUtils.parameterize(org.xwiki.filter.input.InputSourceConverter.class, (Type[])new Type[]{value.getClass()});
            ComponentManager componentManager = (ComponentManager)this.contextComponentManagerProvider.get();
            if (componentManager.hasComponent((Type)componentRole)) {
                try {
                    org.xwiki.filter.input.InputSourceConverter converter = (org.xwiki.filter.input.InputSourceConverter)componentManager.getInstance((Type)componentRole);
                    inputSource = converter.convert(value);
                }
                catch (ComponentLookupException e) {
                    throw new ConversionException("Failed to get the input source converter component for type [" + String.valueOf(value.getClass()) + "]", (Throwable)e);
                }
            } else {
                inputSource = this.fromString(value.toString());
            }
        }
        return (G)inputSource;
    }

    private InputSource fromString(String source) {
        try {
            return this.parser.parse(source);
        }
        catch (FilterException e) {
            throw new ConversionException("Failed to parse the inut source reference [" + source + "]", (Throwable)e);
        }
    }
}

