/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.xwiki.filter.FilterDescriptor;
import org.xwiki.filter.FilterElementDescriptor;
import org.xwiki.filter.FilterElementParameterDescriptor;
import org.xwiki.filter.FilterEventParameters;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.UnknownFilter;
import org.xwiki.filter.internal.DefaultFilterDescriptorManager;

public final class FilterProxy
implements InvocationHandler {
    private FilterDescriptor descriptor;
    private Object targetFilter;

    public FilterProxy(Object filter, FilterDescriptor descriptor) {
        this.targetFilter = filter;
        this.descriptor = descriptor;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            FilterProxy.invoke(this.targetFilter, this.descriptor, method, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        return null;
    }

    public static void invoke(Object filter, FilterDescriptor descriptor, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, FilterException {
        if (method.getDeclaringClass().isInstance(filter)) {
            method.invoke(filter, args);
        } else if (filter instanceof UnknownFilter) {
            FilterProxy.invokeUnkown(filter, descriptor, method, args);
        }
    }

    private static void invokeUnkown(Object filter, FilterDescriptor descriptor, Method method, Object[] args) throws FilterException {
        FilterElementDescriptor element;
        String id = DefaultFilterDescriptorManager.getElementName(method);
        if (id != null && (element = descriptor.getElement(id)) != null) {
            FilterEventParameters metadata = new FilterEventParameters();
            for (FilterElementParameterDescriptor<?> parameter : element.getParameters()) {
                metadata.put(parameter.getName() != null ? parameter.getName() : String.valueOf(parameter.getIndex()), args[parameter.getIndex()]);
            }
            UnknownFilter unknownFilter = (UnknownFilter)filter;
            if (method.getName().startsWith("begin")) {
                unknownFilter.beginUnknwon(id, metadata);
            } else if (method.getName().startsWith("end")) {
                unknownFilter.endUnknwon(id, metadata);
            } else if (method.getName().startsWith("on")) {
                unknownFilter.onUnknwon(id, metadata);
            }
        }
    }
}

