/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.util.ReflectionMethodUtils;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.filter.FilterDescriptor;
import org.xwiki.filter.FilterDescriptorManager;
import org.xwiki.filter.FilterElementDescriptor;
import org.xwiki.filter.FilterElementParameterDescriptor;
import org.xwiki.filter.IncompatibleFilterException;
import org.xwiki.filter.annotation.Default;
import org.xwiki.filter.annotation.Name;
import org.xwiki.filter.internal.CompositeFilter;
import org.xwiki.filter.internal.FilterProxy;
import org.xwiki.properties.ConverterManager;
import org.xwiki.properties.converter.ConversionException;

@Component
@Singleton
public class DefaultFilterDescriptorManager
implements FilterDescriptorManager {
    public static final String PREFIX_BEGIN = "begin";
    public static final String PREFIX_END = "end";
    public static final String PREFIX_ON = "on";
    private static final Class<?>[] CLASS_ARRAY = new Class[0];
    private Map<Class<?>, FilterDescriptor> descriptors = new ConcurrentHashMap();
    @Inject
    private ConverterManager converter;
    @Inject
    private Logger logger;

    @Override
    public FilterDescriptor getFilterDescriptor(Class<?> ... interfaces) {
        FilterDescriptor totalDescriptor = null;
        for (Class<?> i : interfaces) {
            FilterDescriptor descriptor = this.descriptors.get(i);
            if (descriptor == null) {
                try {
                    descriptor = this.createDescriptor(i);
                }
                catch (IncompatibleFilterException e) {
                    this.logger.error("Failed to create descriptor for filter [{}]", i, (Object)e);
                    continue;
                }
                this.descriptors.put(i, descriptor);
            }
            if (totalDescriptor == null) {
                totalDescriptor = descriptor;
                continue;
            }
            totalDescriptor.add(descriptor);
        }
        return totalDescriptor;
    }

    public static String getElementName(Method method, boolean searchTopMethod) {
        Method topMethod = method;
        if (searchTopMethod) {
            Set hierarchy = MethodUtils.getOverrideHierarchy((Method)method, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE);
            topMethod = (Method)IterableUtils.get((Iterable)hierarchy, (int)(hierarchy.size() - 1));
        }
        return DefaultFilterDescriptorManager.getElementName(topMethod);
    }

    public static String getElementName(Method method) {
        Name name = method.getAnnotation(Name.class);
        if (name != null) {
            return name.value();
        }
        return DefaultFilterDescriptorManager.getElementName(method.getName());
    }

    public static String getElementName(String methodName) {
        Object elementName = methodName.startsWith(PREFIX_BEGIN) ? methodName.substring(PREFIX_BEGIN.length(), methodName.length()) : (methodName.startsWith(PREFIX_END) ? methodName.substring(PREFIX_END.length(), methodName.length()) : (methodName.startsWith(PREFIX_ON) ? methodName.substring(PREFIX_ON.length(), methodName.length()) : null));
        if (elementName != null) {
            elementName = Character.toLowerCase(((String)elementName).charAt(0)) + ((String)elementName).substring(1, ((String)elementName).length());
        }
        return elementName;
    }

    private FilterDescriptor createDescriptor(Class<?> type) throws IncompatibleFilterException {
        if (Proxy.isProxyClass(type)) {
            return this.getFilterDescriptor(type.getInterfaces());
        }
        FilterDescriptor descriptor = new FilterDescriptor();
        for (Method method : type.getMethods()) {
            Set hierarchy = MethodUtils.getOverrideHierarchy((Method)method, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE);
            Method topMethod = (Method)IterableUtils.get((Iterable)hierarchy, (int)(hierarchy.size() - 1));
            String elementName = DefaultFilterDescriptorManager.getElementName(topMethod);
            if (elementName == null) continue;
            this.addElement(elementName, descriptor, topMethod);
        }
        return descriptor;
    }

    private void addElement(String elementName, FilterDescriptor descriptor, Method method) throws IncompatibleFilterException {
        String lowerElementName = elementName.toLowerCase();
        FilterElementDescriptor element = descriptor.getElements().get(lowerElementName);
        Type[] methodTypes = method.getGenericParameterTypes();
        if (element == null || methodTypes.length > element.getParameters().length) {
            FilterElementParameterDescriptor[] parameters = new FilterElementParameterDescriptor[methodTypes.length];
            for (int i = 0; i < methodTypes.length; ++i) {
                parameters[i] = this.createFilterElementParameter(method, i, methodTypes[i]);
            }
            if (element != null) {
                this.checkCompatible(element, parameters);
            }
            element = new FilterElementDescriptor(elementName, parameters);
            descriptor.getElements().put(lowerElementName, element);
        }
        this.addMethod(element, method);
    }

    private void checkCompatible(FilterElementDescriptor element, FilterElementParameterDescriptor<?>[] parameters) throws IncompatibleFilterException {
        for (FilterElementParameterDescriptor<?> parameter : parameters) {
            FilterElementParameterDescriptor elementParameter = element.getParameter(parameter.getName());
            if (elementParameter == null || elementParameter.getType().equals(parameter.getType())) continue;
            throw new IncompatibleFilterException("Parameter [" + String.valueOf(parameter) + "] is not compatible with parameter [" + String.valueOf(elementParameter) + "] (different types)");
        }
    }

    private FilterElementParameterDescriptor<?> createFilterElementParameter(Method method, int index, Type type) {
        Object defaultValue;
        Parameter parameter;
        List nameAnnotations = ReflectionMethodUtils.getMethodParameterAnnotations((Method)method, (int)index, Name.class, (boolean)true);
        String name = !nameAnnotations.isEmpty() ? ((Name)nameAnnotations.get(0)).value() : ((parameter = method.getParameters()[index]).isNamePresent() ? method.getParameters()[index].getName() : null);
        List defaultAnnotations = ReflectionMethodUtils.getMethodParameterAnnotations((Method)method, (int)index, Default.class, (boolean)true);
        if (!defaultAnnotations.isEmpty()) {
            defaultValue = ((Default)defaultAnnotations.get(0)).value();
            if (defaultValue != null) {
                try {
                    defaultValue = this.converter.convert(type, defaultValue);
                }
                catch (ConversionException e) {
                    if (ReflectionUtils.getTypeClass((Type)type) == Map.class && ((String)defaultValue).isEmpty()) {
                        defaultValue = Collections.EMPTY_MAP;
                    }
                    throw e;
                }
            }
        } else {
            defaultValue = null;
        }
        return new FilterElementParameterDescriptor<String>(index, name, type, (String)defaultValue);
    }

    private void addMethod(FilterElementDescriptor element, Method method) {
        String methodName = method.getName();
        Type[] methodTypes = method.getGenericParameterTypes();
        if (methodName.startsWith(PREFIX_BEGIN)) {
            if (element.getBeginMethod() == null || element.getBeginMethod().getGenericParameterTypes().length < methodTypes.length) {
                element.setBeginMethod(method);
            }
        } else if (methodName.startsWith(PREFIX_END)) {
            if (element.getEndMethod() == null || element.getEndMethod().getGenericParameterTypes().length < methodTypes.length) {
                element.setEndMethod(method);
            }
        } else if (element.getOnMethod() == null || element.getOnMethod().getGenericParameterTypes().length < methodTypes.length) {
            element.setOnMethod(method);
        }
    }

    @Override
    public <F> F createFilterProxy(Object targetFilter, Class<?> ... interfaces) {
        return this.createFilterProxy(targetFilter, Thread.currentThread().getContextClassLoader(), interfaces);
    }

    @Override
    public <F> F createFilterProxy(Object targetFilter, ClassLoader loader, Class<?> ... interfaces) {
        for (Class<?> i : interfaces) {
            if (i.isInstance(targetFilter)) continue;
            return (F)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)new FilterProxy(targetFilter, this.getFilterDescriptor(interfaces)));
        }
        return (F)targetFilter;
    }

    @Override
    public <F> F createCompositeFilter(Object ... filters) {
        return this.createCompositeFilter(Thread.currentThread().getContextClassLoader(), filters);
    }

    @Override
    public <F> F createCompositeFilter(ClassLoader loader, Object ... filters) {
        HashSet interfaces = new HashSet();
        for (Object filter : filters) {
            interfaces.addAll(ClassUtils.getAllInterfaces(filter.getClass()));
        }
        return (F)Proxy.newProxyInstance(loader, interfaces.toArray(CLASS_ARRAY), (InvocationHandler)new CompositeFilter(this, filters));
    }
}

