/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.input;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.filter.AbstractBeanFilterStreamFactory;
import org.xwiki.filter.FilterException;
import org.xwiki.filter.input.BeanInputFilterStream;
import org.xwiki.filter.input.BeanInputFilterStreamFactory;
import org.xwiki.filter.input.InputFilterStream;
import org.xwiki.filter.type.FilterStreamType;

public abstract class AbstractBeanInputFilterStreamFactory<P, F>
extends AbstractBeanFilterStreamFactory<P>
implements BeanInputFilterStreamFactory<P>,
Initializable {
    @Inject
    private ComponentManager componentManager;
    private List<Class<?>> filerInterfaces;

    public AbstractBeanInputFilterStreamFactory(FilterStreamType type) {
        super(type);
    }

    @Override
    public void initialize() throws InitializationException {
        super.initialize();
        ParameterizedType genericType = (ParameterizedType)ReflectionUtils.resolveType(AbstractBeanInputFilterStreamFactory.class, this.getClass());
        this.filerInterfaces = Arrays.asList(ReflectionUtils.getTypeClass((Type)genericType.getActualTypeArguments()[1]));
    }

    @Override
    public Collection<Class<?>> getFilterInterfaces() throws FilterException {
        return this.filerInterfaces;
    }

    @Override
    public InputFilterStream createInputFilterStream(Map<String, Object> properties) throws FilterException {
        return this.createInputFilterStream(this.createPropertiesBean(properties));
    }

    @Override
    public BeanInputFilterStream<P> createInputFilterStream(P properties) throws FilterException {
        BeanInputFilterStream inputFilter;
        try {
            inputFilter = (BeanInputFilterStream)this.componentManager.getInstance((Type)new DefaultParameterizedType(null, BeanInputFilterStream.class, new Type[]{this.getPropertiesBeanClass()}), this.getType().serialize());
        }
        catch (ComponentLookupException e) {
            throw new FilterException(String.format("Failed to get instance of [%s] for type [%s]", BeanInputFilterStream.class, this.getType()), e);
        }
        inputFilter.setProperties(properties);
        return inputFilter;
    }
}

