/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.filter.descriptor;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xwiki.filter.descriptor.FilterStreamDescriptor;
import org.xwiki.filter.descriptor.FilterStreamPropertyDescriptor;

public abstract class AbstractFilterStreamDescriptor
implements FilterStreamDescriptor {
    protected String name;
    protected String description;
    protected Map<String, FilterStreamPropertyDescriptor<?>> parameterDescriptorMap = new LinkedHashMap();

    public AbstractFilterStreamDescriptor(String name, String description) {
        this.name = name;
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public <T> FilterStreamPropertyDescriptor<T> getPropertyDescriptor(String propertyName) {
        return this.parameterDescriptorMap.get(propertyName);
    }

    @Override
    public Collection<FilterStreamPropertyDescriptor<?>> getProperties() {
        return Collections.unmodifiableCollection(this.parameterDescriptorMap.values());
    }
}

